/*!\file: enthalpy_core.cpp
 * \brief: core of the enthalpy solution 
 */ 

#include "./analyses.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../modules/modules.h"
#include "../shared/shared.h"
#include "../solutionsequences/solutionsequences.h"

void enthalpy_core(FemModel* femmodel){

	/*intermediary*/
	bool   save_results;

	//first recover parameters common to all solutions
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);

	if(VerboseSolution()) _printf0_("   computing enthalpy\n");
	femmodel->SetCurrentConfiguration(EnthalpyAnalysisEnum);
	solutionsequence_nonlinear(femmodel,true);

	/*transfer enthalpy to enthalpy picard for the next step: */
	InputDuplicatex(femmodel,EnthalpyEnum,EnthalpyPicardEnum);

	if(save_results){
		if(VerboseSolution()) _printf0_("   saving results\n");
		InputToResultx(femmodel,TemperatureEnum);
		InputToResultx(femmodel,EnthalpyEnum);
		InputToResultx(femmodel,WaterfractionEnum);
		InputToResultx(femmodel,WatercolumnEnum);
		InputToResultx(femmodel,BasalforcingsMeltingRateEnum);
	}
}
