/*!\file SegRef.c
 * \brief: implementation of the SegRef object
 */

/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../classes.h"
#include "../../shared/shared.h"
/*}}}*/

/*Element macros*/
#define NUMNODESP1  2

/*Object constructors and destructor*/
/*FUNCTION SegRef::SegRef(){{{*/
SegRef::SegRef(){
	this->element_type_list=NULL;
}
/*}}}*/
/*FUNCTION SegRef::SegRef(int* types,int nummodels){{{*/
SegRef::SegRef(const int nummodels){

	/*Only allocate pointer*/
	element_type_list=xNew<int>(nummodels);

}
/*}}}*/
/*FUNCTION SegRef::~SegRef(){{{*/
SegRef::~SegRef(){
	xDelete<int>(element_type_list);
}
/*}}}*/

/*Management*/
/*FUNCTION SegRef::SetElementType{{{*/
void SegRef::SetElementType(int type,int type_counter){

	/*initialize element type*/
	this->element_type_list[type_counter]=type;
}
/*}}}*/

/*Reference Element numerics*/

