/*!\file Seg.cpp
 * \brief: implementation of the Segment object
 */
/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../classes.h"
#include "../../shared/shared.h"
/*}}}*/

/*Element macros*/
#define NUMVERTICES 2
/*Constructors/destructor/copy*/
/*FUNCTION Seg::Seg(){{{*/
Seg::Seg(){
	this->nodes      = NULL;
	this->vertices   = NULL;
	this->material   = NULL;
	this->matpar     = NULL;
	this->inputs     = NULL;
	this->parameters = NULL;
	this->results    = NULL;
}
/*}}}*/
/*FUNCTION Seg::Seg(int id, int sid,int index, IoModel* iomodel,int nummodels){{{*/
Seg::Seg(int seg_id, int seg_sid, int index, IoModel* iomodel,int nummodels)
		:SegRef(nummodels),ElementHook(nummodels,index+1,2,iomodel){

			/*id: */
			this->id  = seg_id;
			this->sid = seg_sid;

			//this->parameters: we still can't point to it, it may not even exist. Configure will handle this.
			this->parameters = NULL;

			/*intialize inputs and results: */
			this->inputs  = new Inputs();
			this->results = new Results();

			/*initialize pointers:*/
			this->nodes    = NULL;
			this->vertices = NULL;
			this->material = NULL;
			this->matpar   = NULL;

		}
/*}}}*/
/*FUNCTION Seg::~Seg(){{{*/
Seg::~Seg(){
	delete inputs;
	delete results;
	this->parameters=NULL;
}
/*}}}*/
/*FUNCTION Seg::copy {{{*/
Object* Seg::copy() {
	_error_("not implemented yet");
}
/*}}}*/

/*FUNCTION Seg::Echo{{{*/
void Seg::Echo(void){
	_printf_("Seg:\n");
	_printf_("   id: " << id << "\n");
	if(nodes){
		nodes[0]->Echo();
		nodes[1]->Echo();
	}
	else _printf_("nodes = NULL\n");

	if (material) material->Echo();
	else _printf_("material = NULL\n");

	if (matpar) matpar->Echo();
	else _printf_("matpar = NULL\n");

	_printf_("   parameters\n");
	if (parameters) parameters->Echo();
	else _printf_("parameters = NULL\n");

	_printf_("   inputs\n");
	if (inputs) inputs->Echo();
	else _printf_("inputs=NULL\n");

	if (results) results->Echo();
	else _printf_("results=NULL\n");
}
/*}}}*/
/*FUNCTION Seg::DeepEcho{{{*/
void Seg::DeepEcho(void){

	_printf_("Seg:\n");
	_printf_("   id: " << id << "\n");
	if(nodes){
		nodes[0]->DeepEcho();
		nodes[1]->DeepEcho();
	}
	else _printf_("nodes = NULL\n");

	if (material) material->DeepEcho();
	else _printf_("material = NULL\n");

	if (matpar) matpar->DeepEcho();
	else _printf_("matpar = NULL\n");

	_printf_("   parameters\n");
	if (parameters) parameters->DeepEcho();
	else _printf_("parameters = NULL\n");

	_printf_("   inputs\n");
	if (inputs) inputs->DeepEcho();
	else _printf_("inputs=NULL\n");

	if (results) results->DeepEcho();
	else _printf_("results=NULL\n");

	return;
}
/*}}}*/
/*FUNCTION Seg::ObjectEnum{{{*/
int Seg::ObjectEnum(void){

	return SegEnum;

}
/*}}}*/
/*FUNCTION Seg::Id {{{*/
int    Seg::Id(){

	return id;

}
/*}}}*/
