/*
 * CreateElementsNodesAndMaterialsStressbalanceHoriz.c:
 */

#include "../../toolkits/toolkits.h"
#include "../../classes/classes.h"
#include "../../shared/shared.h"
#include "./ModelProcessorx.h"

void	CreateElementsVerticesAndMaterials(Elements** pelements,Vertices** pvertices,Materials** pmaterials, IoModel* iomodel,const int nummodels){

	/*Intermediary*/
	int i;
	int materials_type;
	bool control_analysis;
	bool dakota_analysis;

	/*DataSets: */
	Elements  *elements  = NULL;
	Vertices  *vertices  = NULL;
	Materials *materials = NULL;

	/*Fetch parameters: */
	iomodel->Constant(&control_analysis,InversionIscontrolEnum);
	iomodel->Constant(&dakota_analysis,QmuIsdakotaEnum);
	iomodel->Constant(&materials_type,MaterialsEnum);

	/*Did we already create the elements? : */
	if(*pelements)return;

	/*First create the elements, vertices, nodes and material properties, if they don't already exist */
	elements  = new Elements();
	vertices  = new Vertices();
	materials = new Materials();

	/*Create elements*/
	if(control_analysis)iomodel->FetchData(3,InversionControlParametersEnum,InversionMinParametersEnum,InversionMaxParametersEnum);
	switch(iomodel->meshtype){
		case Mesh2DhorizontalEnum:
			materials->InputDuplicate(MaterialsRheologyBbarEnum,QmuMaterialsRheologyBEnum);
			for(i=0;i<iomodel->numberofelements;i++){
				if(iomodel->my_elements[i]) elements->AddObject(new Tria(i+1,i,i,iomodel,nummodels));
			}
			break;
		case Mesh2DverticalEnum:
			for(i=0;i<iomodel->numberofelements;i++){
				if(iomodel->my_elements[i]) elements->AddObject(new Tria(i+1,i,i,iomodel,nummodels));
			}
			break;
		#ifdef _HAVE_3D_
		case Mesh3DEnum:
			iomodel->FetchData(2,MeshUpperelementsEnum,MeshLowerelementsEnum);
			for(i=0;i<iomodel->numberofelements;i++){
				if(iomodel->my_elements[i]) elements->AddObject(new Penta(i+1,i,i,iomodel,nummodels));
			}
			break;
		#endif
		default:
			_error_("Mesh not supported yet");
	}

	/*Create materials*/
	switch(materials_type){
		case MaticeEnum:
			iomodel->FetchData(3,MaterialsRheologyBEnum,MaterialsRheologyNEnum,DamageDEnum);
			for (i=0;i<iomodel->numberofelements;i++) if(iomodel->my_elements[i]) materials->AddObject(new Matice(i+1,i,iomodel));
			if(dakota_analysis){
				switch(iomodel->meshtype){
					case Mesh2DhorizontalEnum:
						materials->InputDuplicate(MaterialsRheologyBbarEnum,QmuMaterialsRheologyBEnum);
						break;
				   #ifdef _HAVE_3D_
					case Mesh3DEnum:
						materials->InputDuplicate(MaterialsRheologyBEnum,QmuMaterialsRheologyBEnum); 
						break;
				   #endif
					default:
						_error_("Mesh not supported yet");
				}
			}
			break;
		default:
			_error_("Materials "<<EnumToStringx(materials_type)<<" not supported");
	}

	/*Free data: */
	iomodel->DeleteData(8,MeshUpperelementsEnum,MeshLowerelementsEnum,
				MaterialsRheologyBEnum,MaterialsRheologyNEnum,DamageDEnum,InversionControlParametersEnum,InversionMinParametersEnum,
				InversionMaxParametersEnum);

	/*Add new constant material property to materials, at the end: */
	materials->AddObject(new Matpar(iomodel->numberofelements+1,iomodel));//put it at the end of the materials

	/*Create vertices: */

	/*Fetch data:*/
	iomodel->FetchData(6,MeshXEnum,MeshYEnum,MeshZEnum,BedEnum,ThicknessEnum,MaskIceLevelsetEnum);
	CreateNumberNodeToElementConnectivity(iomodel);

	for(i=0;i<iomodel->numberofvertices;i++){
		if(iomodel->my_vertices[i]) vertices->AddObject(new Vertex(i+1,i,i,iomodel));
	}

	/*Free data: */
	iomodel->DeleteData(6,MeshXEnum,MeshYEnum,MeshZEnum,BedEnum,ThicknessEnum,MaskIceLevelsetEnum);

	/*Assign output pointer: */
	*pelements=elements;
	*pvertices=vertices;
	*pmaterials=materials;
}
