/*! \file CreateLoadsDiagnosticHoriz.c:
 */

#undef __FUNCT__ 
#define __FUNCT__ "CreateLoadsDiagnosticHoriz"

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../Model.h"


void	CreateLoadsDiagnosticHoriz(DataSet** ploads, Model* model,ConstDataHandle model_handle){

	int i;
	int element;

	extern int my_rank;
	extern int num_procs;
	
	DataSet*    loads    = NULL;
	Icefront*   icefront = NULL;
	Riftfront*  riftfront= NULL;

	int segment_width;
	int element_type;
	int i1,i2,i3,i4;
	int i0,range;

		
	/*icefront intermediary data: */
	char icefront_type[ICEFRONTSTRING];
	int icefront_element_type;
	int	icefront_sid;
	int icefront_eid;
	int icefront_mparid;
	int	icefront_node_ids[MAX_ICEFRONT_GRIDS];
	double icefront_h[MAX_ICEFRONT_GRIDS];
	double	icefront_b[MAX_ICEFRONT_GRIDS];

	/*rifts: */
	char riftfront_type[RIFTFRONTSTRING];
	int  riftfront_id;
	int  riftfront_node_ids[2];
	int  riftfront_mparid;
	double riftfront_h[2];
	double riftfront_b[2];
	double riftfront_s[2];
	double riftfront_normal[2];
	double riftfront_length;
	int    riftfront_fill;
	double riftfront_friction;
	bool   riftfront_shelf;
	double riftfront_penalty_offset;
	int riftfront_penalty_lock;
	bool riftfront_active;
	int  riftfront_counter;
	bool riftfront_prestable;
	int el1,el2;
	int grid1,grid2;
	double normal[2];
	double length;
	int    fill;
	double friction;
	
	/*Create loads: */
	loads   = new DataSet(LoadsEnum());

	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
	if (!model->ismacayealpattyn)goto cleanup_and_return;
	
	/*Create pressure loads as boundary conditions. Pay attention to the partitioning if we are running in parallel (the grids
	 * referenced by a certain load must belong to the cluster node): */
	ModelFetchData((void**)&model->segmentonneumann_diag,&model->numberofsegs_diag,NULL,model_handle,"segmentonneumann_diag","Matrix","Mat");
	ModelFetchData((void**)&model->elements_type,NULL,NULL,model_handle,"elements_type","Matrix","Mat");
	ModelFetchData((void**)&model->thickness,NULL,NULL,model_handle,"thickness","Matrix","Mat");
	ModelFetchData((void**)&model->bed,NULL,NULL,model_handle,"bed","Matrix","Mat");

	/*First load data:*/
	for (i=0;i<model->numberofsegs_diag;i++){
		
		if (strcmp(model->meshtype,"2d")==0){
			segment_width=3;
			element_type=TriaEnum();
		}
		else{
			segment_width=5;
			element_type=PentaEnum();
		}


		element=(int)(*(model->segmentonneumann_diag+segment_width*i+segment_width-1)-1); //element is in the last column

		#ifdef _PARALLEL_
		if (model->epart[element]!=my_rank){
			/*This load does not belong to this cluster node, as it references an element 
			 *that does not belong to this node's partition. Drop this 'i':*/
			continue;
		}
		#endif
	
		icefront_mparid=model->numberofelements+1; //matlab indexing
		icefront_sid=i+1; //matlab indexing
		icefront_eid=(int)*(model->segmentonneumann_diag+segment_width*i+segment_width-1); //matlab indexing
		icefront_element_type=element_type;

		i1=(int)*(model->segmentonneumann_diag+segment_width*i+0);
		i2=(int)*(model->segmentonneumann_diag+segment_width*i+1);
			
		icefront_node_ids[0]=i1;
		icefront_node_ids[1]=i2;
		
		icefront_h[0]=model->thickness[i1-1];
		icefront_h[1]=model->thickness[i2-1];

		icefront_b[0]=model->bed[i1-1];
		icefront_b[1]=model->bed[i2-1];
		
		if ((int)*(model->elements_type+2*element+0)==MacAyealEnum()){ //this is a collapsed 3d element, icefront will be 2d
			strcpy(icefront_type,"segment");
		}
		else if ((int)*(model->elements_type+2*element+0)==PattynEnum()){ //this is a real 3d element, icefront will be 3d.
			strcpy(icefront_type,"quad");
			i3=(int)*(model->segmentonneumann_diag+segment_width*i+2);
			i4=(int)*(model->segmentonneumann_diag+segment_width*i+3);
			icefront_node_ids[2]=i3;
			icefront_node_ids[3]=i4;
			
			icefront_h[2]=model->thickness[i3-1];
			icefront_h[3]=model->thickness[i4-1];

			icefront_b[2]=model->bed[i3-1];
			icefront_b[3]=model->bed[i4-1];
		}
		else{
			throw ErrorException(__FUNCT__,exprintf(" element type %i not supported yet",(int)*(model->elements_type+2*element+0)));
		}

		icefront = new Icefront(icefront_type,icefront_sid,icefront_mparid,icefront_eid,icefront_element_type,icefront_node_ids,icefront_h,icefront_b);
		
		loads->AddObject(icefront);

	}
	/*Free data: */
	xfree((void**)&model->segmentonneumann_diag);
	xfree((void**)&model->elements_type);
	xfree((void**)&model->thickness);
	xfree((void**)&model->bed);

	/*Create penpair loads also for rift grids, so that they don't penetrate one another, if needed: */
	/*First fetch rifts: */
	ModelFetchData((void**)&model->riftinfo,&model->numrifts,NULL,model_handle,"riftinfo","Matrix","Mat");
	ModelFetchData((void**)&model->thickness,NULL,NULL,model_handle,"thickness","Matrix","Mat");
	ModelFetchData((void**)&model->bed,NULL,NULL,model_handle,"bed","Matrix","Mat");
	ModelFetchData((void**)&model->surface,NULL,NULL,model_handle,"surface","Matrix","Mat");
	ModelFetchData((void**)&model->gridoniceshelf,NULL,NULL,model_handle,"gridoniceshelf","Matrix","Mat");

	if(model->numrifts){
		for(i=0;i<model->numrifts;i++){
				
			el1=(int)*(model->riftinfo+9*i+2);
			#ifdef _PARALLEL_
			if (model->epart[el1-1]!=my_rank){
				/*This load does not belong to this cluster node, as it references an element 
				 *that does not belong to this node's partition. Drop this 'j':*/
				continue;
			}
			#endif

			/*Ok, retrieve all the data needed to add a penalty between the two grids: */
			el2=(int)*(model->riftinfo+9*i+3); 

			grid1=(int)*(model->riftinfo+9*i+0); 
			grid2=(int)*(model->riftinfo+9*i+1);
			
			normal[0]=*(model->riftinfo+9*i+4);
			normal[1]=*(model->riftinfo+9*i+5);
			length=*(model->riftinfo+9*i+6);
			
			fill = (int)*(model->riftinfo+9*i+7);
			friction=*(model->riftinfo+9*i+8);
	
			strcpy(riftfront_type,"2d");
			riftfront_id=i+1; //matlab indexing
			riftfront_node_ids[0]=grid1;
			riftfront_node_ids[1]=grid2;
			riftfront_mparid=model->numberofelements+1; //matlab indexing

			riftfront_h[0]=model->thickness[grid1-1];
			riftfront_h[1]=model->thickness[grid2-1];

			riftfront_b[0]=model->bed[grid1-1];
			riftfront_b[1]=model->bed[grid2-1];

			riftfront_s[0]=model->surface[grid1-1];
			riftfront_s[1]=model->surface[grid2-1];

			riftfront_normal[0]=normal[0];
			riftfront_normal[1]=normal[1];
			riftfront_length=length;
			
			riftfront_fill=fill;
			riftfront_friction=friction;
			riftfront_shelf=(bool)model->gridoniceshelf[grid1-1];

			riftfront_penalty_offset=model->penalty_offset;
			riftfront_penalty_lock=model->penalty_lock;

			riftfront_active=0;
			riftfront_counter=0;
			riftfront_prestable=0;
			
			riftfront=new Riftfront(riftfront_type,riftfront_id, riftfront_node_ids, riftfront_mparid, riftfront_h,riftfront_b,riftfront_s,riftfront_normal,riftfront_length,riftfront_fill,riftfront_friction, riftfront_penalty_offset, riftfront_penalty_lock, riftfront_active,riftfront_counter,riftfront_prestable,riftfront_shelf);

			loads->AddObject(riftfront);
		}
	}

	/*free ressources: */
	xfree((void**)&model->riftinfo);
	xfree((void**)&model->thickness);
	xfree((void**)&model->bed);
	xfree((void**)&model->surface);
	xfree((void**)&model->gridoniceshelf);

	cleanup_and_return:

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	loads->Presort();

	/*Assign output pointer: */
	*ploads=loads;

}


