/*!\file PostprocessingEnthalpyx.cpp
 * \brief: execute processing of variables after computation: water drainage, subglacial melting rates, update of thermal BCs
 */

#include "./PostprocessingEnthalpyx.h"
#include "../../shared/shared.h"
#include "../../toolkits/toolkits.h"

void PostprocessingEnthalpyx(FemModel* femmodel){
    /*Intermediary*/
	int i;
	Element* element=NULL;
	
	/*Compute basal melting rates: */
	for (i=0;i<femmodel->elements->Size();i++){
		element=dynamic_cast<Element*>(femmodel->elements->GetObjectByOffset(i));
		element->ComputeBasalMeltingrate();
	}

	/*drain excess water fraction: */
	for (i=0;i<femmodel->elements->Size();i++){
		element=dynamic_cast<Element*>(femmodel->elements->GetObjectByOffset(i));
		element->DrainWaterfraction();
	}

	/*Update basal dirichlet BCs for enthalpy: */
	for (i=0;i<femmodel->elements->Size();i++){
		element=dynamic_cast<Element*>(femmodel->elements->GetObjectByOffset(i));
		element->UpdateBasalConstraintsEnthalpy();
	}
}
