/*!\file Massfluxatgate.h
 * \brief: header file for Massfluxatgate object
 */

#ifndef _MASSFLUXATGATE_H_
#define _MASSFLUXATGATE_H_

/*Headers:*/
/*{{{*/
#include "../shared/shared.h"
#include "../datastructures/datastructures.h"
/*}}}*/

template <class doubletype>
class Massfluxatgate: public Object{

	public: 

		char*       name;
		int         numsegments;
		doubletype *x1;
		doubletype *y1;
		doubletype *x2;
		doubletype *y2;
		int*        elements;

		/*Massfluxatgate constructors, destructors :*/
		/*FUNCTION Massfluxatgate() {{{*/
		Massfluxatgate(){
			this->name     = 0;
			this->numsegments     = 0;
			this->segments   = 0;
		}
		/*}}}*/
		/*FUNCTION Massfluxatgate(char* name, int numsegments, doubletype* segments) {{{*/
		Massfluxatgate(char* in_name, int in_numsegments, doubletype* in_segments) {

			this->name   = xNew<char>(strlen(in_name)+1);
			xMemCpy<char>(this->name,in_name,strlen(in_name)+1);

			this->numsegments=in_numsegments;

			if(this->numsegments){
				this->x1=xNew<doubletype>(this->numsegments);
				this->x2=xNew<doubletype>(this->numsegments);
				this->y1=xNew<doubletype>(this->numsegments);
				this->y2=xNew<doubletype>(this->numsegments);
				this->elements=xNew<int>(this->numsegments);

				for(i=0;i<this->numsegments;i++){
					this->x1[i]=in_segments[5*i+0];
					this->y1[i]=in_segments[5*i+1];
					this->x2[i]=in_segments[5*i+2];
					this->y2[i]=in_segments[5*i+3];
					this->elements[i]=(int)in_segments[5*i+4];
				}
			}
		}
		/*}}}*/
		/*FUNCTION Massfluxatgate(char* name, int numsegments, doubletype* x1, doubletype* y1, doubletype* x2, doubletype* y2,int* elements) {{{*/
		Massfluxatgate(char* in_name, int in_numsegments, doubletype* in_x1, doubletype* in_y1, doubletype* in_x2, doubletype* in_y2,int* in_elements){

			this->name   = xNew<char>(strlen(in_name)+1);
			xMemCpy<char>(this->name,in_name,strlen(in_name)+1);

			this->numsegments=in_numsegments;

			if(this->numsegments){
				this->x1=xNew<doubletype>(this->numsegments); xMemCpy<doubletype>(this->x1,in_x1,this->numsegments);
				this->y1=xNew<doubletype>(this->numsegments); xMemCpy<doubletype>(this->y1,in_y1,this->numsegments);
				this->x2=xNew<doubletype>(this->numsegments); xMemCpy<doubletype>(this->x2,in_x2,this->numsegments);
				this->y2=xNew<doubletype>(this->numsegments); xMemCpy<doubletype>(this->y2,in_y2,this->numsegments);
				this->elements=xNew<int>(this->numsegments); xMemCpy<int>(this->elements,in_elements,this->numsegments);
				
			}
		}
		/*}}}*/
		/*FUNCTION ~Massfluxatgate() {{{*/
		~Massfluxatgate(){
			xDelete<doubletype>(this->x1);
			xDelete<doubletype>(this->y1);
			xDelete<doubletype>(this->x2);
			xDelete<doubletype>(this->y2);
			xDelete<int>(this->elements);
			xDelete<char>(this->name);
		}
		/*}}}*/

		/*Object virtual function resolutoin: */
		/*FUNCTION Echo(){{{*/
		void Echo(void){
			_printf_(" Massfluxatgate: " << name << "\n");
			_printf_("    numsegments: " << numsegments << "\n");
			if(numsegments){
				_printf_("   element: x1, y1, x2, y2:\n");
				for(int i=0;i<numsegments;i++){
					_printf_(elements[i] << " " << x1[i] << " " << y1[i] << " " << x2[i] << " " << y2[i] << "\n");
				}
			}
		}
		/*}}}*/
		/*FUNCTION DeepEcho(){{{*/
		void DeepEcho(void){
			this->Echo();
		}
		/*}}}*/
		/*FUNCTION Id(){{{*/
		int Id(void){
			return -1;
		}
		/*}}}*/
		/*FUNCTION ObjectEnum{{{*/
		int ObjectEnum(void){
			return MassfluxatgateEnum;
		}
		/*}}}*/
		/*FUNCTION copy {{{*/
		Object* copy() {
			return new Massfluxatgate(this->name,this->numsegments,this->); 
		}
		/*}}}*/
};

#endif  /* _MASSFLUXATGATE_H_ */
