/*!\file: CreateParametersOutputDefinitions.cpp
 * \brief driver for creating output definitions dataset, and including it into the parameters dataset
 */ 

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void CreateParametersOutputDefinitions(Parameters** pparameters,IoModel* iomodel,int solution_type,int analysis_type){

	Parameters *parameters = NULL;
	DataSet* output_definitions=NULL;

	/*Get parameters: */
	parameters=*pparameters;

	output_definitions=new DataSet();
	
	iomodel->FetchData(&output_definition_enums,&num_output_definitions,NULL,OutputdefinitionEnumsEnum); 
	if(num_output_definitions){
		for (i=0;i<num_output_definitions;i++){

			if (output_definition_enums[i]==MassfluxatgateEnum){

				/*Fetch segments and names: */
				iomodel->FetchMultipleData(&gatenames,&numgates,MassfluxatgateNameEnum);
				iomodel->FetchMultipleData(&gatesegments,&gatesegments_M,&gatesegments_N,&numgates,MassfluxatgateSegmentsEnum);
				for(j=0;j<numgates;j++){
					output_definitions->AddObject(new Massfluxgate(gatenames[i],gatesegments[i],gatesegments_M[i],gatesegments_N[i]));
				}
			}
			else _error_("output definition enum " << output_definition_enums[i] << "not supported yet!");
		}
	}
	parameters->AddObject(new DataSetParam(OutputdefinitionEnum,output_definitions);

	
	/*Assign output pointer: */
	*pparameters=parameters;
}
