/*!\file: CreateParameters.cpp
 * \brief general driver for creating parameters dataset
 */ 

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../toolkits/toolkits.h"
#include "../../classes/classes.h"
#include "../../shared/shared.h"
#include "../MeshPartitionx/MeshPartitionx.h"
#include "../ParseToolkitsOptionsx/ParseToolkitsOptionsx.h"
#include "./ModelProcessorx.h"

void CreateParameters(Parameters** pparameters,IoModel* iomodel,char* rootpath,FILE* toolkitsoptionsfid,const int solution_type,int analysis_type,int analysis_counter){

	int         i,j,m,k;
	int         numoutputs,meshtype;
	Parameters *parameters       = NULL;
	IssmDouble *requestedoutputs = NULL;
	IssmDouble  time;
	bool        ispdd,isdelta18o;

	if(*pparameters)return; //do not create parameters twice!

	/*Initialize dataset: */
	parameters = new Parameters();

	/*Copy some constants from iomodel */
	parameters->AddObject(iomodel->CopyConstantObject(MeshTypeEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SettingsOutputFrequencyEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SteadystateReltolEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SteadystateMaxiterEnum));
	parameters->AddObject(iomodel->CopyConstantObject(ConstantsYtsEnum));
	parameters->AddObject(iomodel->CopyConstantObject(TimesteppingStartTimeEnum));
	parameters->AddObject(iomodel->CopyConstantObject(TimesteppingFinalTimeEnum));
	parameters->AddObject(iomodel->CopyConstantObject(TimesteppingTimeAdaptEnum));
	parameters->AddObject(iomodel->CopyConstantObject(TimesteppingTimeStepEnum));
	parameters->AddObject(iomodel->CopyConstantObject(TimesteppingCflCoefficientEnum));
	parameters->AddObject(iomodel->CopyConstantObject(MasstransportIsfreesurfaceEnum));
	parameters->AddObject(iomodel->CopyConstantObject(MasstransportHydrostaticAdjustmentEnum));
	parameters->AddObject(iomodel->CopyConstantObject(MasstransportStabilizationEnum));
	parameters->AddObject(iomodel->CopyConstantObject(MasstransportMinThicknessEnum));
	parameters->AddObject(iomodel->CopyConstantObject(MasstransportPenaltyFactorEnum));
	parameters->AddObject(iomodel->CopyConstantObject(ThermalPenaltyFactorEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SettingsLowmemEnum));
	parameters->AddObject(iomodel->CopyConstantObject(DebugProfilingEnum));
	parameters->AddObject(iomodel->CopyConstantObject(MeshAverageVertexConnectivityEnum));
	parameters->AddObject(iomodel->CopyConstantObject(ConstantsReferencetemperatureEnum));
	parameters->AddObject(iomodel->CopyConstantObject(BalancethicknessStabilizationEnum));
	parameters->AddObject(iomodel->CopyConstantObject(GroundinglineMeltingRateEnum));
	parameters->AddObject(iomodel->CopyConstantObject(ThermalMaxiterEnum));
	parameters->AddObject(iomodel->CopyConstantObject(ThermalStabilizationEnum));
	parameters->AddObject(iomodel->CopyConstantObject(ThermalPenaltyThresholdEnum));
	parameters->AddObject(iomodel->CopyConstantObject(ThermalPenaltyLockEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SettingsWaitonlockEnum));
	parameters->AddObject(iomodel->CopyConstantObject(MeshNumberofelementsEnum));
	parameters->AddObject(iomodel->CopyConstantObject(MeshNumberofverticesEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SettingsIoGatherEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SettingsResultsAsPatchesEnum));
	parameters->AddObject(iomodel->CopyConstantObject(GroundinglineMigrationEnum));
	parameters->AddObject(iomodel->CopyConstantObject(TransientIsstressbalanceEnum));
	parameters->AddObject(iomodel->CopyConstantObject(TransientIsmasstransportEnum));
	parameters->AddObject(iomodel->CopyConstantObject(TransientIsthermalEnum));
	parameters->AddObject(iomodel->CopyConstantObject(TransientIsgroundinglineEnum));
	parameters->AddObject(iomodel->CopyConstantObject(TransientIsgiaEnum));
	parameters->AddObject(iomodel->CopyConstantObject(ThermalIsenthalpyEnum));
	parameters->AddObject(iomodel->CopyConstantObject(ThermalIsdynamicbasalspcEnum));
	parameters->AddObject(iomodel->CopyConstantObject(MaterialsRheologyLawEnum));
	parameters->AddObject(iomodel->CopyConstantObject(AutodiffIsautodiffEnum));
	parameters->AddObject(iomodel->CopyConstantObject(QmuIsdakotaEnum));
	parameters->AddObject(iomodel->CopyConstantObject(InversionIscontrolEnum));
	parameters->AddObject(iomodel->CopyConstantObject(InversionTaoEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SurfaceforcingsIspddEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SurfaceforcingsIsdelta18oEnum));
	parameters->AddObject(iomodel->CopyConstantObject(SurfaceforcingsIssmbgradientsEnum));
	parameters->AddObject(iomodel->CopyConstantObject(GiaCrossSectionShapeEnum));

	/*For stress balance only*/
	if(iomodel->meshtype==Mesh3DEnum)
	 parameters->AddObject(iomodel->CopyConstantObject(MeshNumberoflayersEnum));

	iomodel->Constant(&ispdd,SurfaceforcingsIspddEnum);
	if(ispdd){

		parameters->AddObject(iomodel->CopyConstantObject(SurfaceforcingsDesfacEnum));
		parameters->AddObject(iomodel->CopyConstantObject(SurfaceforcingsS0pEnum));

		iomodel->Constant(&isdelta18o,SurfaceforcingsIsdelta18oEnum);
		if(isdelta18o){
			IssmDouble *temp = NULL;
			IssmDouble  yts;
			int         N,M;

			iomodel->Constant(&yts,ConstantsYtsEnum);

			iomodel->FetchData(&temp,&N,&M,SurfaceforcingsDelta18oEnum); _assert_(N==2);
			for(i=0;i<M;i++) temp[M+i]=yts*temp[M+i];
			parameters->AddObject(new TransientParam(SurfaceforcingsDelta18oEnum,&temp[0],&temp[M],M));
			iomodel->DeleteData(temp,SurfaceforcingsDelta18oEnum);

			iomodel->FetchData(&temp,&N,&M,SurfaceforcingsDelta18oSurfaceEnum); _assert_(N==2);
			for(i=0;i<M;i++) temp[M+i]=yts*temp[M+i];
			parameters->AddObject(new TransientParam(SurfaceforcingsDelta18oSurfaceEnum,&temp[0],&temp[M],M));
			iomodel->DeleteData(temp,SurfaceforcingsDelta18oSurfaceEnum);
		}
	}

	/*some parameters that did not come with the iomodel: */
	parameters->AddObject(new IntParam(SolutionTypeEnum,solution_type));
	parameters->AddObject(new IntParam(AnalysisTypeEnum,analysis_type));
	parameters->AddObject(new IntParam(AnalysisCounterEnum,analysis_counter));

	iomodel->Constant(&time,TimesteppingStartTimeEnum);
	parameters->AddObject(new DoubleParam(TimeEnum,time));  //start at time 0 by default for all solutions FIXME: to be deleted
	parameters->AddObject(new IntParam(StepEnum,1));  //start at time 0 by default for all solutions FIXME: to be deleted

	/*By default, save all results*/
	parameters->AddObject(new BoolParam(SaveResultsEnum,true));

	iomodel->FetchData(&requestedoutputs,&numoutputs,NULL,TransientRequestedOutputsEnum);
	parameters->AddObject(new IntParam(TransientNumRequestedOutputsEnum,numoutputs));
	if(numoutputs)parameters->AddObject(new IntVecParam(TransientRequestedOutputsEnum,requestedoutputs,numoutputs));
	iomodel->DeleteData(requestedoutputs,TransientRequestedOutputsEnum);

	iomodel->FetchData(&requestedoutputs,&numoutputs,NULL,SteadystateRequestedOutputsEnum);
	parameters->AddObject(new IntParam(SteadystateNumRequestedOutputsEnum,numoutputs));
	if(numoutputs)parameters->AddObject(new IntVecParam(SteadystateRequestedOutputsEnum,requestedoutputs,numoutputs));
	iomodel->DeleteData(requestedoutputs,SteadystateRequestedOutputsEnum);

	iomodel->FetchData(&requestedoutputs,&numoutputs,NULL,MasstransportRequestedOutputsEnum);
	parameters->AddObject(new IntParam(MasstransportNumRequestedOutputsEnum,numoutputs));
	if(numoutputs)parameters->AddObject(new IntVecParam(MasstransportRequestedOutputsEnum,requestedoutputs,numoutputs));
	iomodel->DeleteData(requestedoutputs,MasstransportRequestedOutputsEnum);

	/*Output definitions dataset: */
	CreateOutputDefinitions(&parameters,iomodel);

	/*Solution specific parameters*/
	#ifdef _HAVE_HYDROLOGY_
	CreateParametersHydrologyShreve(&parameters,iomodel,solution_type,analysis_type);
	CreateParametersHydrologyDCInefficient(&parameters,iomodel,solution_type,analysis_type);
	CreateParametersHydrologyDCEfficient(&parameters,iomodel,solution_type,analysis_type);
	#endif
	
	#ifdef _HAVE_DAMAGE_
	CreateParametersDamage(&parameters,iomodel,solution_type,analysis_type);
	#endif

	/*Before returning, create parameters in case we are running Qmu or control types runs: */
	#ifdef _HAVE_CONTROL_
	CreateParametersControl(&parameters,iomodel,solution_type,analysis_type);
	#endif

	#ifdef _HAVE_DAKOTA_
	CreateParametersDakota(&parameters,iomodel,rootpath,solution_type,analysis_type);
	#endif

	#ifdef _HAVE_STRESSBALANCE_
	CreateParametersStressbalance(&parameters,iomodel,solution_type,analysis_type);
	#endif


	/*Now, deal with toolkits options, which need to be put into the parameters dataset: */
	ParseToolkitsOptionsx(parameters,toolkitsoptionsfid);

 	#ifdef _HAVE_ADOLC_
	CreateParametersAutodiff(&parameters,iomodel,solution_type,analysis_type);
	#endif

	/*Assign output pointer: */
	*pparameters=parameters;
}
