%CONSTANTS class definition
%
%   Usage:
%      outputdefinition=outputdefinition();

classdef outputdefinition
	properties (SetAccess=public) 
		list                 = {};
	end
	methods
		function obj = outputdefinition(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			obj.list={};

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			md = checkfield(md,'outputdefinition.list','cell',1);

			for i=1:length(obj.list),
				md=checkconsistency(obj.list{i},md,solution,analyses);
			end

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   outputdefinition:'));
			fielddisplay(obj,'list','list of potential outputs that can be requested, but which need additional data to be defined');

		end % }}}
		function marshall(obj,md,fid) % {{{

		for i=1:length(obj.list),
			obj.list{i}.marshall(md,fid);
		end
		end % }}}
	end
end
