%MASSFLUXATGATE class definition
%
%   Usage:
%      massfluxatgate=massfluxatgate();

classdef massfluxatgate
	properties (SetAccess=public)  
		%massfluxatgate 
		name                = '';
		profilename            = ''; 
	end
	properties (SetAccess=private)  
		segments            = NaN;
	end
	methods
		function obj = massfluxatgate(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					obj.name=varargin{1};
				case 2
					obj.name=varargin{1};
					obj.profilename=varargin{2};
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{
		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{
			
			md = checkfield(md,'massfluxatgate.name','empty',1);
			md = checkfield(md,'massfluxatgate.profilename','empty',1);

			%check the profilename points to a file!: 
			if exist(profilename,'file'),
				error('massfluxatgate error message: file name for profile corresponding to gate does not point to a legitimate file on disk!');
			end
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   Massfluxatgate:\n'));

			fielddisplay(obj,'name','identifier for this massfluxatgate response');
			fielddisplay(obj,'profilename','name of file (shapefile or argus file) defining a profile (or gate)');
			
		end % }}}
		function marshall(obj,md,fid) % {{{

		%before marshalling, we need to create the segments out of the profilename: 
		obj.segments=MeshProfileIntersection(md.mesh.elements,md.mesh.x,md.mesh.y,obj.profilename);

		%ok, marshall name and segments: 
		WriteData(fid,'object',obj,'fieldname','name','format','String');
		WriteData(fid,'object',obj,'fieldname','segments','format','DoubleMat','mattype',1);

		end % }}}
	end
end
