/*!\file:  FacesPartitioning.cpp
 * \brief: partition elements and nodes and vertices
 */ 

#include <string.h>
#include "../../classes/classes.h"
#include "../../shared/shared.h"
#include "./ModelProcessorx.h"

void FacesPartitioning(bool** pmy_faces,IoModel* iomodel){

	/*Intermediaries*/
	int  el1,el2;
	bool my_face;

	/*Check Iomodel properties*/
	if(iomodel->meshtype!=Mesh2DhorizontalEnum) _error_("only 2d model are supported");

	/*Get faces and elements*/
	CreateFaces(iomodel);

	/*output: */
	bool* my_faces=xNew<bool>(iomodel->numberoffaces);

	for(int i=0;i<iomodel->numberoffaces;i++){

		/*Get left and right elements*/
		el1=iomodel->faces[4*i+2]-1; //faces are [node1 node2 elem1 elem2]
		el2=iomodel->faces[4*i+3]-1; //faces are [node1 node2 elem1 elem2]

		/*Check whether we should include this face (el2 is -2 for boundary faces)*/
		my_face = iomodel->my_elements[el1];
		if(!my_face && el2>=0){
			my_face = iomodel->my_elements[el2];
		}

		my_faces[i] = my_face;
	}

	/*Free data and assign output pointers */
	*pmy_faces=my_faces;
}
