/*
 * CreateNodesBalancethickness.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	CreateNodesBalancethickness(Nodes** pnodes, IoModel* iomodel){

	/*Fetch parameters: */
	int  stabilization;
	iomodel->Constant(&stabilization,BalancethicknessStabilizationEnum);

	/*Check in 3d*/
	if(stabilization==3 && iomodel->meshtype==Mesh3DEnum) _error_("DG 3d not implemented yet");

	/*First fetch data: */
	if(iomodel->meshtype==Mesh3DEnum) iomodel->FetchData(2,MeshVertexonbedEnum,MeshVertexonsurfaceEnum);
	if(stabilization!=3){
		CreateNodes(pnodes,iomodel,BalancethicknessAnalysisEnum,P1Enum);
	}
	else{
		CreateNodes(pnodes,iomodel,BalancethicknessAnalysisEnum,P1DGEnum);
	}
	iomodel->DeleteData(2,MeshVertexonbedEnum,MeshVertexonsurfaceEnum);
}
