function Shp2Exp(expfilename,shapefilename)
%SHP2EXP- transform shape file to Argus .exp file
%
%   Usage:
%      Shp2Exp(expfilename,shapefilename);
%
%   Example:
%      Shp2Exp('Domain.exp','Domain.shp');
%
%   See also EXPMASTER, EXPDOC

	if ~exist(shapefilename,'file'),
		error(['Shapefile ' shapefilename ' does not exist']);
	end
	shp=shaperead(shapefilename);

	exp=struct([]);
	for i=1:length(shp),
		if strcmpi(shp(i).Geometry,'Polygon'),
			x=shp(i).X; y=shp(i).Y;
			ids=find(isnan(x));
			x(ids)=[]; y(ids)=[];

			exp(end+1).x=x;
			exp(end).y=y;
			exp(end).nods=length(x);
			exp(end).density=1;
			exp(end).closed=1;
			exp(end).name=num2str(shp(i).id);
		end
	end

	expwrite(exp,expfilename);
