function [grids,y_g]=SpcGrids(grids,constraints)
%SPCGRIDS - spc the grids
%
%   Go through the grids and figure out which are spcd
%
%   Usage:
%      [grids,y_g]=SpcGrids(grids,constraints)

%initialize y_g, vector of constraint values in the g-set:
y_g=sparse(getdofcount(grids),1);

%Go through constraints and add constraint on gridset list of corresponding grid
for i=1:length(constraints),

	constraint=constraints(i).constraint;
	if strcmpi(constraint.type,'spc'),
		constraint_grid=grids(constraint.grid).grid;
		
		%for the constrained grid, add the correct degree of freedom in the gridset list 
		constraint_grid.gridset=[constraint_grid.gridset num2str(constraint.dof)]; %concatenate two strings

		%plug modified grid back into grids dataset.
		grids(constraint.grid).grid=constraint_grid;

		%plug value of constraint in corresponding constraint vector y_g
		dof=constraint_grid.doflist(constraint.dof);
		y_g(dof)=constraint.value;
	end
end 

