function grids=Dof(grids)
%DOF - assign the degrees of freedom to each grid
%
%   Establish the degrees of freedom that exist on each grid. For each grid, 
%   we default to 6 degrees of freedom, 3 in translation and 3 in rotation (Nastran convention)
%   When running serially, the dofs (degrees of freedom) are setup incrementaly,  6 for each grid. 
%   In parallel, things are a bit more complex. We want grids belonging to the same partition to 
%   be side by side in the global system matrices, to improve the sparsity pattern.  We also want 
%   the border grids, grids that belong to several partitions, to be lumped at the end of the dof list. 
%
%   Usage:
%      grids=Dof(grids)

dofcount=length(grids)*6;

dof=1;
for i=1:length(grids),
	grids(i).grid.doflist=dof:1:(dof+5);
	dof=dof+6;
end
