function BuildGridSets(grids,constraints)
%BUILDGRIDSETS - build the different grid sets
%
%   Several grid sets are needed to solve the finite element problem
%   o the gset table of degrees of freedom contains 
%     all the degrees of freedom for each grid (6)
%   o the sset table of degrees of freedom contains 
%     all the degrees of freedom that are spcd
%   o the fset table of degrees of freedom contains 
%     all the degrees of freedom that are free (gset-sset)
%   o the fset table of degrees of freedom contains 
%     all the degrees of freedom that linked (2d-3d junction for example)
%
%   Usage:
%      BuildGridSets(grids,constraints)

global gridset

mset=zeros(getdofcount(grids),1);
nset=zeros(getdofcount(grids),1);
sset=zeros(getdofcount(grids),1);
fset=zeros(getdofcount(grids),1);

%First build mutually exclusive m and n sets
%see NastranRgbDoc documentation in theoryguide directory.
nset(:)=1; %everyone is in the n set, except if it is the leading dof of an rgb.
for i=1:length(constraints)
	constraint=constraints(i).constraint;
	if strcmpi(constraint.type,'rgb'),
		grid1=constraint.grid1;
		grid2=constraint.grid2;
		dof=constraint.dof;
		dof1=grids(grid1).grid.doflist(dof);
		dof2=grids(grid2).grid.doflist(dof);
		if (mset(dof1)==1),
			%this dof is already in the mset!
			if mset(dof2)==1,
				%ok, we have identical rgbs, do nothing
			else
				mset(dof2)=1;
				nset(dof2)=0;
			end
		else
			mset(dof1)=1;
			nset(dof1)=0;
		end
	end
end

%Build gridset table of degrees of freedom -> s degrees (the ones that are constrained with an spc -> s for spc)
%the f degrees of freedom (the rest, called f set -> f for free)
for i=1:length(grids),
	grid=grids(i).grid;

	if isempty(grid),continue;end;

	%if dof 1 is spc'ed, put it in the sset, otherwise, in the fset
	if ~isempty(findstr(grid.gridset,'1')), sset(grid.doflist(1))=1; else fset(grid.doflist(1))=1; end
	if ~isempty(findstr(grid.gridset,'2')), sset(grid.doflist(2))=1; else fset(grid.doflist(2))=1; end
	if ~isempty(findstr(grid.gridset,'3')), sset(grid.doflist(3))=1; else fset(grid.doflist(3))=1; end
	if ~isempty(findstr(grid.gridset,'4')), sset(grid.doflist(4))=1; else fset(grid.doflist(4))=1; end
	if ~isempty(findstr(grid.gridset,'5')), sset(grid.doflist(5))=1; else fset(grid.doflist(5))=1; end
	if ~isempty(findstr(grid.gridset,'6')), sset(grid.doflist(6))=1; else fset(grid.doflist(6))=1; end
end

%First build mset vector

%m and n set are mutually exclusive! For now, we assume no spc is on an mpc!
pos=find(mset);
fset(pos)=0;
sset(pos)=0;
nset(pos)=0;

gridset.pv_m=pos; 
gridset.msize=length(pos);

pos=find(nset);
gridset.pv_n=pos;
gridset.nsize=length(pos);


%now, n set splits into s and f set
n_sset=sset(gridset.pv_n);
n_fset=fset(gridset.pv_n);

pos=find(n_sset);
gridset.pv_s=pos;
gridset.ssize=length(pos);

pos=find(n_fset);
gridset.pv_f=pos; 
gridset.fsize=length(pos);


gridset.gsize=gridset.msize+gridset.nsize; %no need for flags, as all dofs belong to the g set



end
