/*!\file: thermal_core.cpp
 * \brief: core of the thermal solution 
 */ 

#include "./analyses.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"
#include "../solutionsequences/solutionsequences.h"

void thermal_core(FemModel* femmodel){

	/*intermediary*/
	bool   save_results;
	bool   dakota_analysis  = false;
	int    solution_type;

	//first recover parameters common to all solutions
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);
	femmodel->parameters->FindParam(&dakota_analysis,QmuIsdakotaEnum);
	femmodel->parameters->FindParam(&solution_type,SolutionTypeEnum);

	if(dakota_analysis && solution_type!=TransientSolutionEnum){
		InputDuplicatex(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,QmuVxMeshEnum,VxMeshEnum);
		InputDuplicatex(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,QmuVyMeshEnum,VyMeshEnum);
		InputDuplicatex(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,QmuVzMeshEnum,VzMeshEnum);
		InputDuplicatex(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,QmuTemperatureEnum,TemperatureEnum);
		InputDuplicatex(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,QmuMeltingEnum,BasalforcingsMeltingRateEnum);
		InputDuplicatex(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,QmuMaterialsRheologyBEnum,MaterialsRheologyBEnum);
		femmodel->SetCurrentConfiguration(ThermalAnalysisEnum);
		ResetConstraintsx(femmodel);
	}

	if(VerboseSolution()) _printf0_("   setting basal Dirichlet boundary conditions\n");
	femmodel->UpdateThermalBasalConstraintsx();

	if(VerboseSolution()) _printf0_("   computing temperatures\n");
	femmodel->SetCurrentConfiguration(ThermalAnalysisEnum);
	solutionsequence_thermal_nonlinear(femmodel);

	if(VerboseSolution()) _printf0_("   computing melting\n");
	femmodel->SetCurrentConfiguration(MeltingAnalysisEnum);
	solutionsequence_linear(femmodel);

	if(save_results){
		if(VerboseSolution()) _printf0_("   saving results\n");
		InputToResultx(femmodel,TemperatureEnum);
		InputToResultx(femmodel,BasalforcingsMeltingRateEnum);
	}
}
