/*!\file ResetConstraintsx
 * \brief: reset thermal penalties
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./ResetConstraintsx.h"
#include "../../shared/shared.h"
#include "../../toolkits/toolkits.h"
#include "../ConstraintsStatex/ConstraintsStatex.h"

void ResetConstraintsx(FemModel* femmodel){

	/*Display message*/
	if(VerboseModule()) _printf0_("   Resetting penalties\n");

	/*recover parameters: */
	int analysis_type;
	femmodel->parameters->FindParam(&analysis_type,AnalysisTypeEnum);

	/*Do we have penalties linked to rifts? In this case, run our special rifts penalty 
	 * management routine, otherwise, skip : */
	#ifdef _HAVE_RIFTS_
	if(RiftIsPresent(femmodel->loads,analysis_type)){
		_error_("rift constraints reset not supported yet!");
	}
	#endif
	#ifdef _HAVE_THERMAL_
	if(PengridIsPresent(femmodel->loads,ThermalAnalysisEnum)){
		ThermalConstraintsReset(femmodel->loads,analysis_type);
	}
	#endif
	#ifdef _HAVE_DAMAGE_
	if(PengridIsPresent(femmodel->loads,DamageEvolutionAnalysisEnum)){
		DamageConstraintsReset(femmodel->loads,analysis_type);
	}
	#endif

}
