/*!\file:  DamageConstraintsState.cpp
 * \brief  damage constraints reset
 */ 

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./ResetConstraintsx.h"

void  DamageConstraintsReset(Loads* loads, int configuration_type){

	int i;

	/*Enforce constraints: */
	for(i=0;i<loads->Size();i++){
		Object* object=(Object*)loads->GetObjectByOffset(i);
		Load* load=(Load*)object;
		if(load->InAnalysis(configuration_type)){
			if(object->ObjectEnum()==PengridEnum){

				Pengrid* pengrid=(Pengrid*)object;
				pengrid->ResetConstraint();
			}
		}
	}
}
