/*
 * \brief: solutionsequence_damage_nonlinear.cpp: core of the damage solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"

void solutionsequence_damage_nonlinear(FemModel* femmodel){

	/*solution : */
	Vector<IssmDouble>* Dg=NULL; 
	Vector<IssmDouble>* Df=NULL; 
	Vector<IssmDouble>* Df_old=NULL; 
	Vector<IssmDouble>* ys=NULL; 

	/*intermediary: */
	Matrix<IssmDouble>* Kff=NULL;
	Matrix<IssmDouble>* Kfs=NULL;
	Vector<IssmDouble>* pf=NULL;
	Vector<IssmDouble>* df=NULL;

	bool converged;
	int constraints_converged;
	int num_unstable_constraints;
	int count;
	int damage_penalty_threshold;
	int damage_maxiter;

	/*parameters:*/
	int  configuration_type;

	/*Recover parameters: */
	femmodel->parameters->FindParam(&damage_penalty_threshold,DamagePenaltyThresholdEnum);
	femmodel->parameters->FindParam(&configuration_type,ConfigurationTypeEnum);
	femmodel->parameters->FindParam(&damage_maxiter,DamageMaxiterEnum);

	count=1;
	converged=false;

	InputUpdateFromConstantx(femmodel,true,ResetPenaltiesEnum);
	InputUpdateFromConstantx(femmodel,false,ConvergedEnum);
	femmodel->UpdateConstraintsx();

	for(;;){

		delete Df_old; Df_old=Df;
		SystemMatricesx(&Kff, &Kfs, &pf,&df, NULL,femmodel);
		CreateNodalConstraintsx(&ys,femmodel->nodes,configuration_type);
		Reduceloadx(pf, Kfs, ys); delete Kfs;
		Solverx(&Df, Kff, pf,Df_old, df, femmodel->parameters);
		delete Kff;delete pf;delete Dg; delete df;
		Mergesolutionfromftogx(&Dg, Df,ys,femmodel->nodes,femmodel->parameters); delete ys;
		InputUpdateFromSolutionx(femmodel,Dg);

		ConstraintsStatex(&constraints_converged,&num_unstable_constraints,femmodel);

		if (!converged){
			if(VerboseConvergence()) _printf0_("   #unstable constraints = " << num_unstable_constraints << "\n");
			if (num_unstable_constraints <= damage_penalty_threshold)converged=true;
			if (count>=damage_maxiter){
				converged=true;
				_printf0_("   maximum number of iterations (" << damage_maxiter << ") exceeded\n"); 
			}
		}
		count++;

		InputUpdateFromConstantx(femmodel,converged,ConvergedEnum);

		if(converged)break;
	}

	InputUpdateFromSolutionx(femmodel,Dg);

	/*Free ressources: */
	delete Dg;
	delete Df;
	delete Df_old;
}
