/*!\file:  AnalysisConfiguration.cpp
 * \brief: return type of analyses, number of analyses 
 */ 

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./analyses.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"
#include "../solutionsequences/solutionsequences.h"

void AnalysisConfiguration(int** panalyses,int* pnumanalyses, int solutiontype){

	/*output: */
	int  numanalyses;
	int* analyses=NULL;

	/*Analyses lists*/
	switch(solutiontype){

		case StressbalanceSolutionEnum:
			numanalyses=5;
			analyses=xNew<int>(numanalyses);
			analyses[0]=StressbalanceAnalysisEnum;
			analyses[1]=StressbalanceVerticalAnalysisEnum;
			analyses[2]=StressbalanceSIAAnalysisEnum;
			analyses[3]=SurfaceSlopeAnalysisEnum;
			analyses[4]=BedSlopeAnalysisEnum;
			break;

		case SteadystateSolutionEnum:
			numanalyses=8;
			analyses=xNew<int>(numanalyses);
			analyses[0]=StressbalanceAnalysisEnum;
			analyses[1]=StressbalanceVerticalAnalysisEnum;
			analyses[2]=StressbalanceSIAAnalysisEnum;
			analyses[3]=SurfaceSlopeAnalysisEnum;
			analyses[4]=BedSlopeAnalysisEnum;
			analyses[5]=EnthalpyAnalysisEnum;
			analyses[6]=ThermalAnalysisEnum;
			analyses[7]=MeltingAnalysisEnum;
			break;

		case ThermalSolutionEnum:
			numanalyses=2;
			analyses=xNew<int>(numanalyses);
			analyses[0]=ThermalAnalysisEnum;
			analyses[1]=MeltingAnalysisEnum;
			break;

		case EnthalpySolutionEnum:
			numanalyses=1;
			analyses=xNew<int>(numanalyses);
			analyses[0]=EnthalpyAnalysisEnum;
			break;

		case HydrologySolutionEnum:
			numanalyses=5;
			analyses=xNew<int>(numanalyses);
			analyses[0]=HydrologyShreveAnalysisEnum;
			analyses[1]=HydrologyDCInefficientAnalysisEnum;
			analyses[2]=HydrologyDCEfficientAnalysisEnum;
			analyses[3]=SurfaceSlopeAnalysisEnum;
			analyses[4]=BedSlopeAnalysisEnum;
			break;

		case MasstransportSolutionEnum:
			numanalyses=1;
			analyses=xNew<int>(numanalyses);
			analyses[0]=MasstransportAnalysisEnum;
			break;

		case BalancethicknessSolutionEnum:
			numanalyses=1;
			analyses=xNew<int>(numanalyses);
			analyses[0]=BalancethicknessAnalysisEnum;
			break;

		case BalancethicknessSoftSolutionEnum:
			numanalyses=1;
			analyses=xNew<int>(numanalyses);
			analyses[0]=BalancethicknessAnalysisEnum;
			break;

		case BalancevelocitySolutionEnum:
			numanalyses=2;
			analyses=xNew<int>(numanalyses);
			analyses[0]=BalancevelocityAnalysisEnum;
			analyses[1]=SurfaceSlopeAnalysisEnum;
			break;

		case SurfaceSlopeSolutionEnum:
			numanalyses=1;
			analyses=xNew<int>(numanalyses);
			analyses[0]=SurfaceSlopeAnalysisEnum;
			break;

		case BedSlopeSolutionEnum:
			numanalyses=1;
			analyses=xNew<int>(numanalyses);
			analyses[0]=BedSlopeAnalysisEnum;
			break;

		case GiaSolutionEnum:
			numanalyses=1;
			analyses=xNew<int>(numanalyses);
			analyses[0]=GiaAnalysisEnum;
			break;
		
		case DamageEvolutionSolutionEnum:
			numanalyses=1;
			analyses=xNew<int>(numanalyses);
			analyses[0]=DamageEvolutionAnalysisEnum;
			break;

		case TransientSolutionEnum:
			numanalyses=11;
			analyses=xNew<int>(numanalyses);
			analyses[ 0]=StressbalanceAnalysisEnum;
			analyses[ 1]=StressbalanceVerticalAnalysisEnum;
			analyses[ 2]=StressbalanceSIAAnalysisEnum;
			analyses[ 3]=SurfaceSlopeAnalysisEnum;
			analyses[ 4]=BedSlopeAnalysisEnum;
			analyses[ 5]=ThermalAnalysisEnum;
			analyses[ 6]=MeltingAnalysisEnum;
			analyses[ 7]=EnthalpyAnalysisEnum;
			analyses[ 8]=MasstransportAnalysisEnum;
			analyses[ 9]=FreeSurfaceBaseAnalysisEnum;
			analyses[10]=FreeSurfaceTopAnalysisEnum;
			break;

		default:
			_error_("solution type: " << EnumToStringx(solutiontype) << " not supported yet!");
			break;
	}

	/*Assign output pointers:*/
	if(pnumanalyses) *pnumanalyses=numanalyses;
	if(panalyses)    *panalyses=analyses;
	else              xDelete<int>(analyses);
}
