function plot_segmentonneumann(md,options_structure,width,i,data);
%PLOT_SEGMENTONNEUMANN - plot segment on neumann BC
%
%   Usage:
%      plot_segmentonneumann(md,options_structure,width,i);
%
%   See also: PLOTMODEL

%plot mesh boundaries
subplot(width,width,i); 

%process mesh and data
[x y z elements is2d]=processmesh(md,options_structure);
if strcmp(data,'segmentonneumann_diag') segmentonneumann=md.segmentonneumann_diag;end
if strcmp(data,'segmentonneumann_prog') segmentonneumann=md.segmentonneumann_prog;end

if strcmpi(md.type,'2d'),

	%plot mesh
	A=elements(:,1); B=elements(:,2); C=elements(:,3); 
	h1=patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	hold on;

	%highlight elements on neumann in Green
	pos=segmentonneumann(:,end);
	A=elements(pos,1); B=elements(pos,2); C=elements(pos,3); 
	h2=patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','green','EdgeColor','black');
	hold on;

	%display arrows pointing outward
	xstart=mean(x(segmentonneumann(:,1:end-1)),2);
	ystart=mean(y(segmentonneumann(:,1:end-1)),2);
	length=sqrt((x(segmentonneumann(:,1))-x(segmentonneumann(:,2))).^2 + (y(segmentonneumann(:,1))-y(segmentonneumann(:,2))).^2 );
	normal(:,1)=cos(atan2((x(segmentonneumann(:,1))-x(segmentonneumann(:,2))) , (y(segmentonneumann(:,2))-y(segmentonneumann(:,1)))));
	normal(:,2)=sin(atan2((x(segmentonneumann(:,1))-x(segmentonneumann(:,2))) , (y(segmentonneumann(:,2))-y(segmentonneumann(:,1)))));
	xend=xstart+length.*normal(:,1);
	yend=ystart+length.*normal(:,2);
	q=quiver(xstart,ystart,xend-xstart,yend-ystart); hold on;
	h3=plot(xstart,ystart,'r*');
else

	%plot mesh
	A=elements(:,1); B=elements(:,2); C=elements(:,3); D=elements(:,4); E=elements(:,5); F=elements(:,6);
	h1=patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [D E F], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [A B E D], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [B E F C ], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [C A D F ], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	hold on;

	%highlight elements on neumann in Green
	pos=segmentonneumann(:,end);
	A=elements(pos,1); B=elements(pos,2); C=elements(pos,3); D=elements(pos,4); E=elements(pos,5); F=elements(pos,6);
	h2=patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','green','EdgeColor','black');
	patch( 'Faces', [D E F], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','green','EdgeColor','black');
	patch( 'Faces', [A B E D], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','green','EdgeColor','black');
	patch( 'Faces', [B E F C ], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','green','EdgeColor','black');
	patch( 'Faces', [C A D F ], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','green','EdgeColor','black');
	hold on;

	%display arrows pointing outward
	xstart=mean(x(segmentonneumann(:,1:end-1)),2);
	ystart=mean(y(segmentonneumann(:,1:end-1)),2);
	zstart=mean(z(segmentonneumann(:,1:end-1)),2);
	length=sqrt((x(segmentonneumann(:,1))-x(segmentonneumann(:,2))).^2 + (y(segmentonneumann(:,1))-y(segmentonneumann(:,2))).^2 );
	normal(:,1)=cos(atan2((x(segmentonneumann(:,1))-x(segmentonneumann(:,2))) , (y(segmentonneumann(:,2))-y(segmentonneumann(:,1)))));
	normal(:,2)=sin(atan2((x(segmentonneumann(:,1))-x(segmentonneumann(:,2))) , (y(segmentonneumann(:,2))-y(segmentonneumann(:,1)))));
	xend=xstart+length.*normal(:,1);
	yend=ystart+length.*normal(:,2);
	q=quiver3(xstart,ystart,zstart,xend-xstart,yend-ystart,0); hold on;
	h3=plot3(xstart,ystart,zstart,'r*');
end

%legend
legend([h2,q],'element on ice front','normal vectors')

%apply options
if isnan(options_structure.title)
	options_structure.title='Neumann boundary conditions';
end 
if isnan(options_structure.colorbar)
	options_structure.colorbar=0;
end
applyoptions(md,[],options_structure);
