from fielddisplay import fielddisplay
from EnumDefinitions import *
from StringToEnum import StringToEnum
from checkfield import *
from WriteData import *

class damage(object):
	"""
	DAMAGE class definition

	   Usage:
	      damage=damage();
	"""

	def __init__(self,*args):    # {{{
			
		#damage: 
		isdamage = float('NaN')
		self.D   = float('NaN')
		self.law   = ''
		
		#parameters for law 'initial': 
		self.stress_threshold    = float('NaN')
		self.c1                  = float('NaN')
		self.c2                  = float('NaN')
		self.c3                  = float('NaN')
		self.c4                  = float('NaN')

		if not len(args):
			self.setdefaultparameters()
		else:
			raise RuntimeError("constructor not supported")

	# }}}
	def __repr__(self):    # {{{
		s ='   Damage:\n'

		s+="%s\n" % fielddisplay(self,"D","damage tensor (scalar for now)")
		s+="%s\n" % fielddisplay(self,"law","damage law (string) from ['undamaged','pralong']")

		if (self.law=='pralong'):
			s+="%s\n" % fielddisplay(self,"c1","damage parameter 1 ")
			s+="%s\n" % fielddisplay(self,"c2","damage parameter 2 ")
			s+="%s\n" % fielddisplay(self,"c3","damage parameter 3 ")
			s+="%s\n" % fielddisplay(self,"c4","damage parameter 4 ")
			s+="%s\n" % fielddisplay(self,"stress_threshold","damage stress threshold [Pa]")

		return s
	# }}}
	def setdefaultparameters(self):    # {{{

		#damage parameters: 
		self.isdamage=0
		self.D=0
		self.law='undamaged'
		self.stress_threshold=0
		self.c1=0
		self.c2=0
		self.c3=0
		self.c4=0

	# }}}
	def checkconsistency(self,md,solution,analyses):    # {{{

		if self.isdamage:
			md = checkfield(md,'damage.D','>=',0,'size',[md.mesh.numberofvertices])
			md = checkfield(md,'damage.law','values',['undamaged','pralong'])
		if self.law == 'pralong':
			md = checkfield(md,'damage.c1','>=',0)
			md = checkfield(md,'damage.c2','>=',0)
			md = checkfield(md,'damage.c3','>=',0)
			md = checkfield(md,'damage.c4','>=',0)
			md = checkfield(md,'damage.stress_threshold','>=',0)

		return md
	# }}}
	def marshall(self,md,fid):    # {{{

		WriteData(fid,'object',self,'class','damage','fieldname','isdamage','format','DoubleMat','mattype',1)
		if self.isdamage:
			WriteData(fid,'object',self,'class','damage','fieldname','D','format','DoubleMat','mattype',1)
			WriteData(fid,'object',self,'class','damage','fieldname','law','format','String')
		if self.law=='pralong':
			WriteData(fid,'object',self,'class','damage','fieldname','c1','format','Double')
			WriteData(fid,'object',self,'class','damage','fieldname','c2','format','Double')
			WriteData(fid,'object',self,'class','damage','fieldname','c3','format','Double')
			WriteData(fid,'object',self,'class','damage','fieldname','c4','format','Double')
			WriteData(fid,'object',self,'class','damage','fieldname','stress_threshold','format','Double')
	# }}}
