/*
 * \file EnumDefinitions.h:
 * \brief: enum functions for our objects
 */

#ifndef _ENUM_DEFINITIONS_
#define _ENUM_DEFINITIONS_

enum definitions{
	/*Model fields {{{*/
	AutodiffIsautodiffEnum, 
	AutodiffNumDependentsEnum,
	AutodiffNumDependentObjectsEnum,
	AutodiffDependentObjectNamesEnum,
	AutodiffDependentObjectTypesEnum,
	AutodiffDependentObjectIndicesEnum,
	AutodiffDependentObjectsEnum,
	AutodiffNumIndependentsEnum,
	AutodiffNumIndependentObjectsEnum,
	AutodiffIndependentObjectNamesEnum,
	AutodiffIndependentObjectTypesEnum,
	AutodiffIndependentObjectsEnum,
	AutodiffJacobianEnum,
	AutodiffXpEnum,
	AutodiffDriverEnum,
	AutodiffFosForwardIndexEnum,
	AutodiffFovForwardIndicesEnum,
	AutodiffFosReverseIndexEnum,
	AutodiffMassFluxSegmentsPresentEnum,
	AutodiffKeepEnum,
	BalancethicknessSpcthicknessEnum,
	BalancethicknessStabilizationEnum,
	BalancethicknessThickeningRateEnum,
	BasalforcingsGeothermalfluxEnum,
	BasalforcingsMeltingRateCorrectionEnum,
	BasalforcingsMeltingRateEnum,
	BathymetryEnum,
	BedEnum,
	ConstantsGEnum,
	ConstantsReferencetemperatureEnum,
	ConstantsYtsEnum,
	DependentObjectEnum,
	StressbalanceAbstolEnum,
	StressbalanceIcefrontEnum,
	StressbalanceIsnewtonEnum,
	StressbalanceMaxiterEnum,
	StressbalanceNumRequestedOutputsEnum,
	StressbalancePenaltyFactorEnum,
	StressbalanceReferentialEnum,
	StressbalanceReltolEnum,
	StressbalanceRequestedOutputsEnum,
	StressbalanceRestolEnum,
	StressbalanceRiftPenaltyLockEnum,
	StressbalanceRiftPenaltyThresholdEnum,
	StressbalanceShelfDampeningEnum,
	StressbalanceSpcvxEnum,
	StressbalanceSpcvyEnum,
	StressbalanceSpcvzEnum,
	StressbalanceFSreconditioningEnum,
	StressbalanceVertexPairingEnum,
	StressbalanceViscosityOvershootEnum,
	LoadingforceXEnum,
	LoadingforceYEnum,
	LoadingforceZEnum,
	FlowequationBorderSSAEnum,
	FlowequationBorderHOEnum,
	FlowequationBorderFSEnum,
	FlowequationElementEquationEnum,
	FlowequationIsSIAEnum,
	FlowequationIsSSAEnum,
	FlowequationIsL1L2Enum,
	FlowequationIsHOEnum,
	FlowequationIsFSEnum,
	FlowequationFeSSAEnum,
	FlowequationFeHOEnum,
	FlowequationFeFSEnum,
	FlowequationVertexEquationEnum,
	FrictionCoefficientEnum,
	FrictionPEnum,
	FrictionQEnum,
	GeometryHydrostaticRatioEnum,
	HydrologyModelEnum,
	HydrologyshreveEnum,
	HydrologyshreveCREnum,
	HydrologyshreveKnEnum,
	HydrologyshreveNEnum,
	HydrologyshrevePEnum,
	HydrologyshreveQEnum,
	HydrologyshreveSpcwatercolumnEnum,
	HydrologyshreveStabilizationEnum,
	HydrologydcEnum,
	SedimentHeadEnum,
	SedimentHeadOldEnum,
	SedimentHeadResidualEnum,
	EplHeadEnum,
	EplHeadOldEnum,
  HydrologydcRelTolEnum,
	HydrologydcSpcsedimentHeadEnum,
	HydrologydcSedimentCompressibilityEnum,
	HydrologydcSedimentPorosityEnum,
	HydrologydcSedimentThicknessEnum,
	HydrologydcSedimentTransmitivityEnum,
	HydrologydcWaterCompressibilityEnum,
	HydrologydcSpceplHeadEnum,
	HydrologydcMaskEplactiveEnum,
	HydrologydcEplCompressibilityEnum,
	HydrologydcEplPorosityEnum,
	HydrologydcEplThicknessEnum,
	HydrologydcEplTransmitivityEnum,
	HydrologydcIsefficientlayerEnum,
	HydrologydcSedimentlimitFlagEnum,
	HydrologydcSedimentlimitEnum,
	HydrologydcTransferFlagEnum,
	HydrologydcLeakageFactorEnum,
	HydrologydcPenaltyFactorEnum,
	HydrologyLayerEnum,
	HydrologySedimentEnum,
	HydrologyEfficientEnum,
	HydrologySedimentKmaxEnum,
	BasisIntegralEnum,
	WaterTransferEnum,
	IndependentObjectEnum,
	InversionControlParametersEnum,
	InversionCostFunctionThresholdEnum,
	InversionCostFunctionsCoefficientsEnum,
	InversionCostFunctionsEnum,
	InversionGradientOnlyEnum,
	InversionGradientScalingEnum,
	InversionIscontrolEnum,
	InversionTaoEnum,
	InversionIncompleteAdjointEnum,
	InversionMaxParametersEnum,
	InversionMaxiterPerStepEnum,
	InversionMinParametersEnum,
	InversionNstepsEnum,
	InversionNumControlParametersEnum,
	InversionNumCostFunctionsEnum,
	InversionStepThresholdEnum,
	InversionThicknessObsEnum,
	InversionVelObsEnum,
	InversionVxObsEnum,
	InversionVyObsEnum,
	InversionVzObsEnum,
	MaskIceLevelsetEnum,
	MaterialsBetaEnum,
	MaterialsHeatcapacityEnum,
	MaterialsLatentheatEnum,
	MaterialsMeltingpointEnum,
	MaterialsMixedLayerCapacityEnum,
	MaterialsRheologyBEnum,
	MaterialsRheologyBbarEnum,
	MaterialsRheologyLawEnum,
	MaterialsRheologyNEnum,
	MaterialsRheologyZEnum,
	MaterialsRheologyZbarEnum,
	MaterialsDamageDEnum,
	MaterialsDamageDbarEnum,
	MaterialsRhoIceEnum,
	MaterialsRhoWaterEnum,
	MaterialsRhoFreshwaterEnum,
	MaterialsMuWaterEnum,
	MaterialsThermalExchangeVelocityEnum,
	MaterialsThermalconductivityEnum,
	MaterialsLithosphereShearModulusEnum,
	MaterialsLithosphereDensityEnum,
	MaterialsMantleShearModulusEnum,
	MaterialsMantleDensityEnum,
	MeshAverageVertexConnectivityEnum,
	MeshDimensionEnum,
	MeshElementonbedEnum,
	MeshElementonsurfaceEnum,
	MeshElements2dEnum,
	MeshElementsEnum,
	MeshLowerelementsEnum,
	MeshNumberofelements2dEnum,
	MeshNumberofelementsEnum,
	MeshNumberoflayersEnum,
	MeshNumberofvertices2dEnum,
	MeshNumberofverticesEnum,
	MeshUpperelementsEnum,
	MeshVertexonbedEnum,
	MeshVertexonsurfaceEnum,
	MeshXEnum,
	MeshYEnum,
	MeshZEnum,
	MiscellaneousNameEnum, //FIXME: only used by qmu, should not be marshalled (already in queueing script)
	MasstransportHydrostaticAdjustmentEnum,
	MasstransportIsfreesurfaceEnum,
	MasstransportMinThicknessEnum,
	MasstransportPenaltyFactorEnum,
	MasstransportSpcthicknessEnum,
	MasstransportStabilizationEnum,
	MasstransportVertexPairingEnum,
	MasstransportNumRequestedOutputsEnum,
	MasstransportRequestedOutputsEnum,
	QmuIsdakotaEnum,
	MassFluxSegmentsEnum,
	MassFluxSegmentsPresentEnum,
	QmuMassFluxSegmentsPresentEnum,
	QmuNumberofpartitionsEnum,
	QmuNumberofresponsesEnum,
	QmuPartitionEnum,
	QmuResponsedescriptorsEnum,
	QmuVariabledescriptorsEnum,
	QmuMaterialsRheologyBEnum,
	RiftsNumriftsEnum,
	RiftsRiftstructEnum,
	SettingsIoGatherEnum,
	SettingsLowmemEnum,
	SettingsOutputFrequencyEnum,
	SettingsResultsAsPatchesEnum,
	SettingsWaitonlockEnum,
	SurfaceforcingsDelta18oEnum,
	SurfaceforcingsDelta18oSurfaceEnum,
	SurfaceforcingsIsdelta18oEnum,
	SurfaceforcingsPrecipitationsPresentdayEnum,
	SurfaceforcingsTemperaturesPresentdayEnum,
	SurfaceforcingsTemperaturesLgmEnum,
	DebugProfilingEnum,
	ProfilingCurrentMemEnum,
	ProfilingCurrentFlopsEnum,
	ProfilingSolutionTimeEnum,
	MaxIterationConvergenceFlagEnum,
	SteadystateMaxiterEnum,
	SteadystateNumRequestedOutputsEnum,
	SteadystateReltolEnum,
	SteadystateRequestedOutputsEnum,
	SurfaceEnum,
	SurfaceforcingsPrecipitationEnum,
	SurfaceforcingsMassBalanceEnum,
	SurfaceforcingsIspddEnum,
	SurfaceforcingsDesfacEnum,
	SurfaceforcingsS0pEnum,
	SurfaceforcingsIssmbgradientsEnum,
	SurfaceforcingsMonthlytemperaturesEnum,
	SurfaceforcingsHrefEnum,
	SurfaceforcingsSmbrefEnum,
	SurfaceforcingsBPosEnum,
	SurfaceforcingsBNegEnum,
	ThermalIsenthalpyEnum,
    	ThermalIsdynamicbasalspcEnum,
	ThermalMaxiterEnum,
	ThermalPenaltyFactorEnum,
	ThermalPenaltyLockEnum,
	ThermalPenaltyThresholdEnum,
	ThermalSpctemperatureEnum,
	ThermalStabilizationEnum,
	GiaMantleViscosityEnum,
	GiaLithosphereThicknessEnum,
	ThicknessEnum,
	TimesteppingStartTimeEnum,
	TimesteppingFinalTimeEnum,
	TimesteppingCflCoefficientEnum,
	TimesteppingTimeAdaptEnum,
	TimesteppingTimeStepEnum,
	TransientIsstressbalanceEnum,
	TransientIsgroundinglineEnum,
	TransientIsmasstransportEnum,
	TransientIsthermalEnum,
	TransientIsgiaEnum,
	TransientNumRequestedOutputsEnum,
	TransientRequestedOutputsEnum,
	/*}}}*/
	/*Solutions and Analyses{{{ */
	SolutionTypeEnum,
	AnalysisTypeEnum,
	ConfigurationTypeEnum,
	AdjointBalancethicknessAnalysisEnum,
	AdjointHorizAnalysisEnum,
	AdjointSolutionEnum,
	AnalysisCounterEnum,
	NoneAnalysisEnum,
	DefaultAnalysisEnum,
	BalancethicknessAnalysisEnum,
	BalancethicknessSolutionEnum,
	BalancethicknessSoftAnalysisEnum,
	BalancethicknessSoftSolutionEnum,
	BalancevelocityAnalysisEnum,
	BalancevelocitySolutionEnum,
	BedSlopeAnalysisEnum,
	BedSlopeSolutionEnum,
	BedSlopeXAnalysisEnum,
	BedSlopeYAnalysisEnum,
	StressbalanceAnalysisEnum,
	StressbalanceSIAAnalysisEnum,
	StressbalanceSolutionEnum,
	StressbalanceVerticalAnalysisEnum,
	EnthalpyAnalysisEnum,
	EnthalpySolutionEnum,
	FlaimAnalysisEnum,
	FlaimSolutionEnum,
	HydrologyShreveAnalysisEnum,
	HydrologyDCInefficientAnalysisEnum,
	HydrologyDCEfficientAnalysisEnum,
	HydrologySolutionEnum,
	MeltingAnalysisEnum,
	MasstransportAnalysisEnum,
	MasstransportSolutionEnum,
	FreeSurfaceBaseAnalysisEnum,
	FreeSurfaceTopAnalysisEnum,
	SteadystateSolutionEnum,
	SurfaceSlopeAnalysisEnum,
	SurfaceSlopeSolutionEnum,
	SurfaceSlopeXAnalysisEnum,
	SurfaceSlopeYAnalysisEnum,
	SmoothedSurfaceSlopeXAnalysisEnum,
	SmoothedSurfaceSlopeYAnalysisEnum,
	ThermalAnalysisEnum,
	ThermalSolutionEnum,
	TransientSolutionEnum,
	GiaSolutionEnum,
	GiaAnalysisEnum,
	/*}}}*/
	/*Approximations {{{*/
	ApproximationEnum,
	NoneApproximationEnum,
	SIAApproximationEnum,
	SSAApproximationEnum,
	SSAHOApproximationEnum,
	SSAFSApproximationEnum,
	L1L2ApproximationEnum,
	HOApproximationEnum,
	HOFSApproximationEnum,
	FSApproximationEnum,
	FSvelocityEnum,
	FSpressureEnum,
	/*}}}*/
	/*Datasets {{{*/
	ConstraintsEnum,
	LoadsEnum,
	MaterialsEnum,
	NodesEnum,
	ContoursEnum,
	ParametersEnum,
	VerticesEnum,
	ResultsEnum,
	/*}}}*/
	/*Objects {{{*/
	GenericParamEnum,
	AdolcParamEnum,
	BoolInputEnum,
	BoolParamEnum,
	ContourEnum,
	ControlInputEnum,
	DatasetInputEnum,
	DofIndexingEnum,
	DoubleInputEnum,
	DataSetParamEnum,
	DoubleMatArrayParamEnum,
	DoubleMatParamEnum,
	DoubleParamEnum,
	DoubleVecParamEnum,
	ElementEnum,
	ElementResultEnum,
	ExternalResultEnum,
	FileParamEnum,
	HookEnum,
	IcefrontEnum,
	InputEnum,
	IntInputEnum,
	IntParamEnum,
	IntVecParamEnum,
	TransientParamEnum,
	IceFrontTypeEnum,
	SSA2dIceFrontEnum,
	SSA3dIceFrontEnum,
	MaticeEnum,
	MatdamageiceEnum,
	MatparEnum,
	NodeEnum,
	NumericalfluxEnum,
	NumericalfluxTypeEnum,
	ParamEnum,
	L1L2IceFrontEnum,
	HOIceFrontEnum,
	PengridEnum,
	PenpairEnum,
	PentaEnum,
	PentaInputEnum,
	ProfilerEnum,
	MatrixParamEnum,
	NodeSIdEnum,
	VectorParamEnum,
	RiftfrontEnum,
	RiftfrontTypeEnum,
	SegmentEnum,
	SegmentRiftfrontEnum,
	SpcDynamicEnum,
	SpcStaticEnum,
	SpcTransientEnum,
	FSIceFrontEnum,
	StringArrayParamEnum,
	StringParamEnum,
	TriaEnum,
	TriaInputEnum,
	VertexEnum,
	VertexPIdEnum,
	VertexSIdEnum,
	/*}}}*/
	/*Fill {{{*/
	AirEnum,
	IceEnum,
	MelangeEnum,
	WaterEnum,
	/*}}}*/
	/*Rift state {{{*/
	ClosedEnum,
	FreeEnum,
	OpenEnum,
	/*}}}*/
	/*Inputs {{{*/
	AdjointpEnum,
	AdjointxEnum,
	AdjointyEnum,
	AdjointzEnum,
	BalancethicknessMisfitEnum,
	BedSlopeXEnum,
	BedSlopeYEnum,
	BoundaryEnum,
	ConstantEnum,
	ConvergedEnum,
	FillEnum,
	FractionIncrementEnum,
	FrictionEnum,
	GroundinglineMeltingRateEnum,
	InternalEnum,
	MassFluxEnum,
	MaxPenetrationEnum,
	MeltingOffsetEnum,
	MisfitEnum,
	NumberNodeToElementConnectivityEnum,
	PressureEnum,
	PressurePicardEnum,
	QmuPressureEnum,
	QmuVxEnum,
	QmuVyEnum,
	QmuVzEnum,
	QmuThicknessEnum,
	QmuBedEnum,
	QmuSurfaceEnum,
	QmuMeltingEnum,
	QmuVxMeshEnum,
	QmuVyMeshEnum,
	QmuVzMeshEnum,
	AndroidFrictionCoefficientEnum,
	ResetPenaltiesEnum,
	SegmentOnIceShelfEnum,
	SurfaceAbsVelMisfitEnum,
	SurfaceAreaEnum,
	SurfaceAverageVelMisfitEnum,
	SurfaceLogVelMisfitEnum,
	SurfaceLogVxVyMisfitEnum,
	SurfaceRelVelMisfitEnum,
	SurfaceSlopeXEnum,
	SurfaceSlopeYEnum,
	TemperatureEnum,
	TemperatureOldEnum,
	TemperaturePicardEnum,
	ThicknessAbsMisfitEnum,
	VelEnum,
	VelocityEnum,
	VxAverageEnum,
	VxEnum,
	VxPicardEnum,
	VyAverageEnum,
	VyEnum,
	VyPicardEnum,
	VzEnum,
	VzSSAEnum,
	VzHOEnum,
	VzPicardEnum,
	VzFSEnum,
	VxMeshEnum,
	VyMeshEnum,
	VzMeshEnum,
	EnthalpyEnum,
	EnthalpyPicardEnum,
	ThicknessAbsGradientEnum,
	ThicknessAlongGradientEnum,
	ThicknessAcrossGradientEnum,
	StepResponsesEnum,
	IntMatParamEnum,
	RheologyBbarAbsGradientEnum,
	DragCoefficientAbsGradientEnum,
	TransientInputEnum,
	WaterfractionEnum,
	WatercolumnEnum,
	BasalFrictionEnum,
	ViscousHeatingEnum,
	QmuTemperatureEnum,
	HydrologyWaterVxEnum,
	HydrologyWaterVyEnum,
	StressTensorEnum,
	StressTensorxxEnum,
	StressTensorxyEnum,
	StressTensorxzEnum,
	StressTensoryyEnum,
	StressTensoryzEnum,
	StressTensorzzEnum,
	GiaCrossSectionShapeEnum,
	GiadWdtEnum,
	GiaWEnum,
	/*}}}*/
	/*Element Interpolations{{{*/
	P0Enum,
	P1Enum,
	P1DGEnum,
	P1bubbleEnum,
	P1bubblecondensedEnum,
	P2Enum,
	P2xP1Enum,
	P1xP2Enum,
	P1P1Enum,
	P1P1GLSEnum,
	MINIEnum,
	MINIcondensedEnum,
	TaylorHoodEnum,
	/*}}}*/
	/*Results{{{*/
	SaveResultsEnum,
	BoolElementResultEnum,
	BoolExternalResultEnum,
	DoubleElementResultEnum,
	DoubleExternalResultEnum,
	DoubleMatExternalResultEnum,
	IntExternalResultEnum,
	JEnum,
	PatchEnum,
	PatchNodesEnum,
	PatchVerticesEnum,
	PentaP1ElementResultEnum,
	StringExternalResultEnum,
	StepEnum,
	TimeEnum,
	TriaP1ElementResultEnum,
	WaterColumnOldEnum,
	/*}}}*/
	/*Responses{{{*/
	MinVelEnum,
	MaxVelEnum,
	MinVxEnum,
	MaxVxEnum,
	MaxAbsVxEnum,
	MinVyEnum,
	MaxVyEnum,
	MaxAbsVyEnum,
	MinVzEnum,
	MaxVzEnum,
	MaxAbsVzEnum,
	IceVolumeEnum,
	TotalSmbEnum,
	/*}}}*/
	/*Relaxation{{{*/
	AbsoluteEnum,
	IncrementalEnum,
	/*}}}*/
	/*Grounding Line{{{*/
	AgressiveMigrationEnum,
	NoneEnum,
	SoftMigrationEnum,
	SubelementMigrationEnum,
	SubelementMigration2Enum,
	MaskGroundediceLevelsetEnum,
	/*}}}*/
	/*Solver{{{*/
	FSSolverEnum,
	/*}}}*/
	/*Parameters{{{*/
	AdjointEnum,
	ColinearEnum,
	ControlSteadyEnum,
	FsetEnum,
	Gradient1Enum,
	Gradient2Enum,
	Gradient3Enum,
	GradientEnum,
	GroundinglineMigrationEnum,
	GsetEnum,
	IndexEnum,
	IndexedEnum,
	IntersectEnum,
	NodalEnum,
	OldGradientEnum,
	OutputFilePointerEnum,
	OutputFileNameEnum,
	LockFileNameEnum,
	ToolkitsOptionsAnalysesEnum,
	ToolkitsOptionsStringsEnum,
	QmuErrNameEnum,
	QmuInNameEnum,
	QmuOutNameEnum,
	RegularEnum,
	ScaledEnum,
	SeparateEnum,
	SsetEnum,
	VerboseEnum,
	/*}}}*/
	/*Interpolation {{{*/
	TriangleInterpEnum,
	BilinearInterpEnum,
	NearestInterpEnum,
	/*}}}*/
	/*Coordinate Systems{{{*/
	XYEnum,
	XYZEnum,
	/*}}}*/
	/*Toolkits{{{*/
	DenseEnum,
	MpiDenseEnum,
	SeqEnum,
	MpiEnum,
	MumpsEnum,
	GslEnum,
	/*}}}*/
	/*Options{{{*/
	OptionEnum,
	GenericOptionEnum,
	OptionCellEnum,
	OptionCharEnum,
	OptionStructEnum,
	OptionDoubleEnum,
	OptionLogicalEnum,
	/*}}}*/
	/*Rheology law (move too Material) {{{*/
	PatersonEnum,
	ArrheniusEnum,
	LliboutryDuvalEnum,
	/*}}}*/
	MaximumNumberOfDefinitionsEnum
};

#endif
