/*!\file Matdamageice.h
 * \brief: header file for matice object
 */

#ifndef MATDAMAGEICE_H_
#define MATDAMAGEICE_H_

/*Headers:*/
/*{{{*/
#include "./Material.h"
class IoModel;
/*}}}*/

class Matdamageice: public Material{

	private: 
		int	   mid;
		Hook* helement;

	public:
		/*Matdamageice constructors, destructors: {{{*/
		Matdamageice();
		Matdamageice(int mid,int i, IoModel* iomodel);
		~Matdamageice();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*Update virtual functions definitions: {{{*/
		void  InputUpdateFromVector(IssmDouble* vector, int name, int type);
		void  InputUpdateFromMatrixDakota(IssmDouble* matrix, int nrow, int ncols, int name, int type);
		void  InputUpdateFromVectorDakota(IssmDouble* vector, int name, int type);
		void  InputUpdateFromConstant(IssmDouble constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromConstant(bool constant, int name);
		void  InputUpdateFromSolution(IssmDouble* solution);
		void  InputUpdateFromIoModel(int index, IoModel* iomodel);
		/*}}}*/
		/*Material virtual functions resolution: {{{*/
		void   InputDuplicate(int original_enum,int new_enum);
		void   Configure(Elements* elements);
		void   GetVectorFromInputs(Vector<IssmDouble>* vector,int input_enum);
		void   SetCurrentConfiguration(Elements* elementsin,Loads* loadsin,Nodes* nodesin,Vertices* verticesin,Materials* materialsin,Parameters* parametersin);
		void   GetViscosity2d(IssmDouble* pviscosity, IssmDouble* pepsilon);
		void   GetViscosity3d(IssmDouble* pviscosity3d, IssmDouble* pepsilon);
		void   GetViscosity3dFS(IssmDouble* pviscosity3d, IssmDouble* epsilon);
		void   GetViscosityComplement(IssmDouble* pviscosity_complement, IssmDouble* pepsilon);
		void   GetViscosityDComplement(IssmDouble* pviscosity_complement, IssmDouble* pepsilon);
		void   GetViscosityDerivativeEpsSquare(IssmDouble* pmu_prime, IssmDouble* pepsilon);
		void   GetViscosityDerivativeEpsSquareFS(IssmDouble* pmu_prime, IssmDouble* pepsilon);
		void   GetViscosity2dDerivativeEpsSquare(IssmDouble* pmu_prime, IssmDouble* pepsilon);
		IssmDouble GetA();
		IssmDouble GetB();
		IssmDouble GetBbar();
		IssmDouble GetN();
		IssmDouble GetZ();
		IssmDouble GetD();
		IssmDouble GetZbar();
		IssmDouble GetDbar();
		bool   IsInput(int name);
		/*}}}*/
};

#endif  /* _MATICE_H_ */
