from model import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *

md=triangle(model(),'../Exp/Square.exp',50000.)
md=setmask(md,'all','')
md=parameterize(md,'../Par/SquareShelfConstrained.py')
md=setflowequation(md,'SSA','all')
md.cluster=generic('name',oshostname(),'np',1)
md.stressbalance.requested_outputs=StressTensorEnum()
md.toolkits.DefaultAnalysis=issmsolver()
md.autodiff.isautodiff=True
md=solve(md,StressbalanceSolutionEnum())

#Fields and tolerances to track changes
field_names     =['Vx','Vy','Vel','Pressure',\
	'StressTensorxx','StressTensoryy','StressTensorxy']
field_tolerances=[1e-13,1e-13,1e-13,1e-13,\
	1e-13,1e-13,1e-13]
field_values=[\
	md.results.StressbalanceSolution.Vx,\
	md.results.StressbalanceSolution.Vy,\
	md.results.StressbalanceSolution.Vel,\
	md.results.StressbalanceSolution.Pressure,\
	md.results.StressbalanceSolution.StressTensorxx,\
	md.results.StressbalanceSolution.StressTensoryy,\
	md.results.StressbalanceSolution.StressTensorxy,\
	]
