from model import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *
from ContourToMesh import *

md=triangle(model(),'../Exp/Square.exp',150000.);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelf.py');
md.extrude(3,2.)
md=setflowequation(md,'FS','all');
md.flowequation.fe_FS='TaylorHood';
md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,StressbalanceSolutionEnum());

#Fields and tolerances to track changes
field_names     =['Vx', 'Vy', 'Vz', 'Vel','Pressure'];
field_tolerances=[1e-7,1e-7,2e-7,1e-7,1e-7];
field_values=[\
	md.results.StressbalanceSolution.Vx,\
	md.results.StressbalanceSolution.Vy,\
	md.results.StressbalanceSolution.Vz,\
	md.results.StressbalanceSolution.Vel,\
	md.results.StressbalanceSolution.Pressure,\
	];
