/*\file IssmConfig.c
 *\brief: get configuration names
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./IssmConfig.h"

void IssmConfigUsage(void){/*{{{*/
	_printf0_("\n");
	_printf0_("   usage: " << __FUNCT__ << "value = IssmConfig('string');\n");
	_printf0_("\n");
}/*}}}*/
WRAPPER(IssmConfig){

	/*input/output*/
	char       *name     = NULL;
	bool        isstring = false;
	IssmDouble  value   = 0.;
	char       *svalue   = NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments: */
	CHECKARGUMENTS(NLHS,NRHS,&IssmConfigUsage);

	/*Fetch inputs: */
	FetchData(&name,NAME);

	/*Core*/
	if(strcmp(name,"_HAVE_MPI_")==0){
		#ifdef _HAVE_MPI_
		value = 1.;
		#else
		value = 0.;
		#endif
	}
	else if(strcmp(name,"_HAVE_DAKOTA_")==0){
		#ifdef _HAVE_DAKOTA_
		value = 1.;
		#else
		value = 0.;
		#endif
	}
	else if(strcmp(name,"_HAVE_MUMPS_")==0){
		#ifdef _HAVE_MUMPS_
		value = 1.;
		#else
		value = 0.;
		#endif
	}
	else if(strcmp(name,"_HAVE_PETSC_")==0){
		#ifdef _HAVE_PETSC_
		value = 1.;
		#else
		value = 0.;
		#endif
	}
	else if(strcmp(name,"_PETSC_MAJOR_")==0){
		#ifdef _PETSC_MAJOR_
		value = IssmDouble(_PETSC_MAJOR_);
		#else
		_error_("_PETSC_MAJOR_ not found in config.h");
		#endif
	}
	else if(strcmp(name,"_DAKOTA_VERSION_")==0){
		#ifdef _DAKOTA_VERSION_
		isstring = true;
		svalue =xNew<char>(strlen(_DAKOTA_VERSION_)+1);
		xMemCpy<char>(svalue,_DAKOTA_VERSION_,(strlen(_DAKOTA_VERSION_)+1));
		#else
		_error_("_DAKOTA_VERSION_ not found in config.h");
		#endif
	}
	else if(strcmp(name,"ISSM_PREFIX")==0){
		isstring = true;
		svalue =xNew<char>(strlen(ISSM_PREFIX)+1);
		xMemCpy<char>(svalue,ISSM_PREFIX,(strlen(ISSM_PREFIX)+1));
	}
	else{
		_error_("variable " << name << " not supported yet");
	}

	/* output: */
	if(isstring)
	 WriteData(VALUE,svalue);
	else
	 WriteData(VALUE,value);

	/*Clean up*/
	xDelete<char>(name);
	xDelete<char>(svalue);

	/*end module: */
	MODULEEND();
}
