from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from WriteData import *

class friction(object):
	"""
	FRICTION class definition

	   Usage:
	      friction=friction();
	"""

	def __init__(self): # {{{
		self.coefficient = float('NaN')
		self.p           = float('NaN')
		self.q           = float('NaN')

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(self): # {{{
		string="Sigma= drag^2 * Neff ^r * u ^s, with Neff=rho_ice*g*thickness+rho_water*g*bed, r=q/p and s=1/p"

		string="%s\n%s"%(string,fielddisplay(self,"coefficient","friction coefficient [SI]"))
		string="%s\n%s"%(string,fielddisplay(self,"p","p exponent"))
		string="%s\n%s"%(string,fielddisplay(self,"q","q exponent"))
		return string
		#}}}
	def setdefaultparameters(self): # {{{
		return self
	#}}}
	def checkconsistency(self,md,solution,analyses):    # {{{

		#Early return
		if StressbalanceAnalysisEnum() not in analyses and ThermalAnalysisEnum() not in analyses:
			return md

		md = checkfield(md,'friction.coefficient','NaN',1,'size',[md.mesh.numberofvertices])
		md = checkfield(md,'friction.q','NaN',1,'size',[md.mesh.numberofelements])
		md = checkfield(md,'friction.p','NaN',1,'size',[md.mesh.numberofelements])

		return md
	# }}}
	def marshall(self,md,fid):    # {{{
		WriteData(fid,'object',self,'fieldname','coefficient','format','DoubleMat','mattype',1)
		WriteData(fid,'object',self,'fieldname','p','format','DoubleMat','mattype',2)
		WriteData(fid,'object',self,'fieldname','q','format','DoubleMat','mattype',2)
	# }}}
