/*!\file OutputRiftsx
 * \brief: output results from stressbalance solution, for rifts. Notably: fraction of 
 * melange, and penetration.
 */

#include "./OutputRiftsx.h"

#include "../../shared/shared.h"
#include "../../toolkits/toolkits.h"

void OutputRiftsx( Vec* priftproperties, Loads* loads, int numrifts){

	/*output: */
	Vec riftproperties=NULL;

	/*Allocate grad_g: */
	riftproperties=NewVec(numrifts,IssmComm::GetComm());

	/*Compute rift properties : */
	loads->OutputRifts(riftproperties);

	/*Assemble vector: */
	VecAssemblyBegin(riftproperties);
	VecAssemblyEnd(riftproperties);

	/*Assign output pointers: */
	*priftproperties=riftproperties;
}
