/*! \file CreateLoadsMelting.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateLoadsMelting(Loads** ploads, IoModel* iomodel){

	/*if 2d: Error*/
	if(iomodel->dim==2) _error_("2d meshes not supported yet");

	/*Recover pointer: */
	Loads* loads=*ploads;

	//create penalties for nodes: no node can have a temperature over the melting point
	iomodel->FetchData(1,MeshVertexonbedEnum);
	CreateSingleNodeToElementConnectivity(iomodel);

	for(int i=0;i<iomodel->numberofvertices;i++){
		if((iomodel->my_vertices[i]==1)){
			if (reCast<int>(iomodel->Data(MeshVertexonbedEnum)[i])){
				loads->AddObject(new Pengrid(iomodel->loadcounter+i+1,i,iomodel,MeltingAnalysisEnum));
			}
		}
	}
	iomodel->DeleteData(1,MeshVertexonbedEnum);

	/*Assign output pointer: */
	*ploads=loads;
}
