/*! \file CreateLoadsHydrologyDCEfficient.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateLoadsHydrologyDCEfficient(Loads** ploads, IoModel* iomodel){

	/*Recover pointer: */
	Loads* loads=*ploads;

	/*Do we really want DC?*/
	int  hydrology_model;
	iomodel->Constant(&hydrology_model,HydrologyModelEnum);
	if(hydrology_model!=HydrologydcEnum) return;

	/*Do we want an efficient layer*/
	bool isefficientlayer;
	iomodel->Constant(&isefficientlayer,HydrologydcIsefficientlayerEnum);
	if(!isefficientlayer) return;

	/*Nothing for now*/

	/*Assign output pointer: */
	*ploads=loads;
}
