/*!\file ConstraintsStatex
 * \brief: set up penalty constraints on loads
 */

#include "./ConstraintsStatex.h"
#include "./ConstraintsStateLocal.h"
#include "../../shared/shared.h"
#include "../../toolkits/toolkits.h"

void ConstraintsStatex(int* pconverged, int* pnum_unstable_constraints,FemModel* femmodel){

	/*output: */
	int converged                  = 0;
	int num_unstable_constraints   = 0;
	int min_mechanical_constraints = 0;
	int analysis_type;

	/*Display message*/
	if(VerboseModule()) _printf0_("   Constraining penalties\n");

	/*recover parameters: */
	femmodel->parameters->FindParam(&min_mechanical_constraints,StressbalanceRiftPenaltyThresholdEnum);
	femmodel->parameters->FindParam(&analysis_type,AnalysisTypeEnum);

	/*Do we have penalties linked to rifts? In this case, run our special rifts penalty 
	 * management routine, otherwise, skip : */

	/*No constraints management by default!:*/
	num_unstable_constraints=0;
	converged=1;

	#ifdef _HAVE_RIFTS_
	if(RiftIsPresent(femmodel->loads,analysis_type)){
		RiftConstraintsState(&converged,&num_unstable_constraints,femmodel->loads,min_mechanical_constraints,analysis_type);
	}
	#endif
	#ifdef _HAVE_THERMAL_
	if(ThermalIsPresent(femmodel->loads,analysis_type)){
		ThermalConstraintsState(femmodel->loads,&converged,&num_unstable_constraints,analysis_type);
	}
	#endif

	/*Assign output pointers: */
	*pconverged=converged;
	*pnum_unstable_constraints=num_unstable_constraints;
}
