/*!\file: surfaceslope_core.cpp
 * \brief: core of the slope solution 
 */ 

#include "./analyses.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../solutionsequences/solutionsequences.h"
#include "../modules/modules.h"

void surfaceslope_core(FemModel* femmodel){

	/*parameters: */
	bool save_results;

	/*Recover some parameters: */
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);

	if(VerboseSolution()) _printf0_("computing slope...\n");

	/*Call on core computations: */
	femmodel->SetCurrentConfiguration(SurfaceSlopeAnalysisEnum,SurfaceSlopeXAnalysisEnum);
	solutionsequence_linear(femmodel);
	femmodel->SetCurrentConfiguration(SurfaceSlopeAnalysisEnum,SurfaceSlopeYAnalysisEnum);
	solutionsequence_linear(femmodel);

	if(save_results){
		if(VerboseSolution()) _printf0_("saving results:\n");
		InputToResultx(femmodel,SurfaceSlopeXEnum);
		InputToResultx(femmodel,SurfaceSlopeYEnum);
	}

}
