try:
	from matplotlib.ticker import MaxNLocator
	import pylab as p
except ImportError:
	print "could not import pylab, matplotlib has not been installed, no plotting capabilities enabled"

def applyoptions(md,data,options):
	'''
	APPLYOPTIONS - apply options to current plot

		Usage:
			applyoptions(md,data,options)

		See also: PLOTMODEL, PARSE_OPTIONS
	'''

	#some defaults (this seems to be adding a field that already exists...)
	#if not isnan(md.mesh.hemisphere):
	#	options.addfielddefault('hemisphere',md.mesh.hemisphere)

	#font {{{
	fontsize=options.getfieldvalue('fontsize',14)
	fontweight=options.getfieldvalue('fontweight','normal')
	fontfamily=options.getfieldvalue('fontfamily','sans-serif')
	font={
			'fontsize'		:fontsize,
			'fontweight'	:fontweight,
			'family'			:fontfamily
			}
	#}}}

	#title {{{
	if options.exist('title'):
		title=options.getfieldvalue('title')
		if options.exist('titlefontsize'):
			titlefontsize=options.getfieldvalue('titlefontsize')
		else:
			titlefontsize=fontsize
		if options.exist('titlefontweight'):
			titlefontweight=options.getfieldvalue('titlefontweight')
		else:
			titlefontweight=fontweight
		#title font
		titlefont=font.copy()
		titlefont['size']=titlefontsize
		titlefont['weight']=titlefontweight
		p.title(title,**titlefont)
	#}}}
		
	#xlabel, ylabel, zlabel {{{
	if options.exist('labelfontsize'):
		labelfontsize=options.getfieldvalue('labelfontsize')
	else:
		labelfontsize=fontsize
	if options.exist('labelfontweight'):
		labelfontweight=options.getfieldvalue('labelfontweight')
	else:
		labelfontweight=fontweight

	#font dict for labels
	labelfont=font.copy()
	labelfont['fontsize']=labelfontsize
	labelfont['fontweight']=labelfontweight

	if options.exist('xlabel'):
		p.xlabel(options.getfieldvalue('xlabel'),**labelfont)
	if options.exist('ylabel'):
		p.ylabel(options.getfieldvalue('ylabel'),**labelfont)
	if options.exist('zlabel'):
		p.zlabel(options.getfieldvalue('zlabel'),**labelfont)
	#}}}

	#xticks, yticks, zticks (tick locations) {{{
	if options.exist('xticks'):
		if options.exist('xticklabels'):
			xticklabels=options.getfieldvalue('xticklabels')
			p.xticks(options.getfieldvalue('xticks'),xticklabels)
		else:
			p.xticks(options.getfieldvalue('xticks'))
	if options.exist('yticks'):
		if options.exist('yticklabels'):
			yticklabels=options.getfieldvalue('yticklabels')
			p.yticks(options.getfieldvalue('yticks'),yticklabels)
		else:
			p.yticks(options.getfieldvalue('yticks'))
	if options.exist('zticks'):
		if options.exist('zticklabels'):
			zticklabels=options.getfieldvalue('zticklabels')
			p.zticks(options.getfieldvalue('zticks'),zticklabels)
		else:
			p.zticks(options.getfieldvalue('zticks'))
	#}}}

	#xticklabels,yticklabels,zticklabels {{{
	if options.exist('xticklabels'):
		xticklabels=options.getfieldvalue('xticklabels')
		xtickloc=p.xticks()[0]	
		p.xticks(xtickloc,xticklabels)
	if options.exist('yticklabels'):
		yticklabels=options.getfieldvalue('yticklabels')
		ytickloc=p.yticks()[0]	
		p.yticks(ytickloc,yticklabels)
	if options.exist('zticklabels'):
		zticklabels=options.getfieldvalue('zticklabels')
		ztickloc=p.zticks()[0]	
		p.zticks(ztickloc,zticklabels)
	#}}}

	#ticklabel notation {{{
	p.gca().ticklabel_format(style='sci',scilimits=(0,0))
	#}}}

	#ticklabelfontsize {{{
	if options.exist('ticklabelfontsize'):
		ax=p.gca()
		for label in ax.get_xticklabels() + ax.get_yticklabels():
			label.set_fontsize(options.getfieldvalue('ticklabelfontsize'))
		if int(md.mesh.dimension)==3: 
			for label in ax.get_zticklabels():
				label.set_fontsize(options.getfieldvalue('ticklabelfontsize'))
	#}}}

	#view

	#axis

	#box

	#xlim, ylim, zlim {{{
	if options.exist('xlim'):
		p.xlim(options.getfieldvalue('xlim'))
	if options.exist('ylim'):
		p.xlim(options.getfieldvalue('ylim'))
	if options.exist('zlim'):
		p.xlim(options.getfieldvalue('zlim'))
	#}}}

	#latlon

	#Basinzoom

	#ShowBasins

	#clim {{{
	if options.exist('clim'):
		lims=options.getfieldvalue('clim')
		if len(lims)!=2:
			print 'WARNING: clim should be passed as a list of length 2'
		else:
			p.clim(lims[0],lims[1])
	#}}}

	#shading

	#grid {{{
	if options.exist('grid'):
		if 'on' in options.getfieldvalue('grid','on'):
			p.grid()
	#}}}

	#colormap

	#wrapping

	#colorbar {{{
	if options.getfieldvalue('colorbar','off')==1:
		cb=p.colorbar()
		cb.locator=MaxNLocator(nbins=5) # default 5 ticks
		cb.update_ticks()
		if options.exist('colorbarnumticks'):
			cb.locator=MaxNLocator(nbins=options.getfieldvalue('colorbarnumticks',5))
			cb.update_ticks()
	#}}}

	#area

	#expdisp

	#text

	#north arrow

	#scale ruler

	#streamlines

	#contours

	#axis positions

	#figure position

	#axes position

	#showregion

	#flat edges of a partition

	#scatter

	#backgroundcolor

	#figurebackgroundcolor

	#lighting

	#point cloud

	#inset
