import numpy
from model import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *

md=triangle(model(),'../Exp/Square.exp',180000)
md=setmask(md,'all','')
md=parameterize(md,'../Par/SquareShelfConstrained.py')
md.extrude(3,1.)
md=setflowequation(md,'SSA','all')
md.timestepping.time_step=0
md.cluster=generic('name',oshostname(),'np',3)
md.initialization.waterfraction=numpy.zeros(md.mesh.numberofvertices)
md.initialization.watercolumn=numpy.zeros(md.mesh.numberofvertices)
md=solve(md,EnthalpySolutionEnum())

#Fields and tolerances to track changes
field_names     =['Enthalpy','Waterfraction','Temperature']
field_tolerances=[1e-13,1.2e-10,1e-13]
field_values=[\
	md.results.EnthalpySolution.Enthalpy,\
	md.results.EnthalpySolution.Waterfraction,\
	md.results.EnthalpySolution.Temperature,\
	]
