from model import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *

md=triangle(model(),'../Exp/Pig.exp',20000.)
md=setmask(md,'../Exp/PigShelves.exp','../Exp/PigIslands.exp')
md=parameterize(md,'../Par/Pig.py')
md.initialization.vx[:]=0.
md.initialization.vy[:]=0.
md=setflowequation(md,'SSA','all')
md.cluster=generic('name',oshostname(),'np',3)
md=solve(md,BalancevelocitySolutionEnum())

# Fields and tolerances to track changes
field_names     =['SurfaceSlopeX','SurfaceSlopeY','Vel']
field_tolerances=[1e-13,1e-13,1e-13]
field_values=[\
		md.results.BalancevelocitySolution.SurfaceSlopeX,\
		md.results.BalancevelocitySolution.SurfaceSlopeY,\
		md.results.BalancevelocitySolution.Vel,\
		]
