function [md package]=testsgetpackage(md,string),
%TESTSGETPACKAGE - build the package from a string
%
%   This routine is used by nightly runs (runme.m and updatearchive.m).
%   for an input string 'cielo_serial', it will output 'cielo'
%
%   Usage:
%      [md package]=testsgetpackage(md,string)
%
%   Example:
%      [md package]=testsgetpackage(md,'cielo_serial')
%
%   See also: TESTSGETANALYSIS, TESTSGETFIELDS

if strcmpi(string,'ice'),
	package='ice';

elseif strcmpi(string,'macayeal'),
	package='macayeal';

elseif strcmpi(string,'cielo_serial'),
	package='cielo';
	md.cluster='none';

elseif strcmpi(string,'cielo_parallel'),
	package='cielo';
	md.cluster=oshostname;
	%check and modify number of cpus if necessary
	np=feature('numCores');
	if np<md.np;
		disp(['testsgetpackage warning: changing number of cpus to ' num2str(np) ]);
		md.np=np;
	end

else
	error(['testsgetpackage error message: package '  string ' not supported yet']);
end
