/*!\file: balancevelocity_core.cpp
 * \brief: core of the balancevelocity solution 
 */ 

#include "./analyses.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"
#include "../solutionsequences/solutionsequences.h"

void balancevelocity_core(FemModel* femmodel){

	/*parameters: */
	bool save_results;


	/*recover parameters: */
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);

	if(VerboseSolution()) _printf0_("call computational core:\n");
	//femmodel->SetCurrentConfiguration(SurfaceSlopeAnalysisEnum,SmoothedSurfaceSlopeXAnalysisEnum);
	//solutionsequence_linear(femmodel);
	//femmodel->SetCurrentConfiguration(SurfaceSlopeAnalysisEnum,SmoothedSurfaceSlopeYAnalysisEnum);
	//solutionsequence_linear(femmodel);
	surfaceslope_core(femmodel);

	if(VerboseSolution()) _printf0_("call computational core:\n");
	femmodel->SetCurrentConfiguration(BalancevelocityAnalysisEnum);
	solutionsequence_linear(femmodel);

	if(save_results){
		if(VerboseSolution()) _printf0_("   saving results\n");
		InputToResultx(femmodel,SurfaceSlopeXEnum);
		InputToResultx(femmodel,SurfaceSlopeYEnum);
		InputToResultx(femmodel,VelEnum);
	}

}
