import os.path
import inspect
import netCDF4
from numpy import *
from verbose import *
from InterpFromMeshToMesh2d import InterpFromMeshToMesh2d
from paterson import *
from SetMarineIceSheetBC import *

#Start defining model parameters here

#Geometry and observation
f         = netCDF4.Dataset('../Data/79North.nc','r')
x         = reshape(f.variables['x'][:],(-1))
y         = reshape(f.variables['y'][:],(-1))
vx        = f.variables['vx'][:]
vy        = f.variables['vy'][:]
index     = f.variables['index'][:]
surface   = f.variables['surface'][:]
thickness = f.variables['thickness'][:]
f.close()

[md.initialization.vx]  = InterpFromMeshToMesh2d(index,x,y,vx,md.mesh.x,md.mesh.y)
[md.initialization.vy]  = InterpFromMeshToMesh2d(index,x,y,vy,md.mesh.x,md.mesh.y)
[md.geometry.surface]   = InterpFromMeshToMesh2d(index,x,y,surface,md.mesh.x,md.mesh.y)
[md.geometry.thickness] = InterpFromMeshToMesh2d(index,x,y,thickness,md.mesh.x,md.mesh.y)
md.geometry.bed         = md.geometry.surface-md.geometry.thickness

#Materials
md.initialization.temperature=(273.-20.)*ones((md.mesh.numberofvertices,1))
md.materials.rheology_B=paterson(md.initialization.temperature)
md.materials.rheology_n=3.*ones((md.mesh.numberofelements,1))
md.initialization.temperature=md.initialization.temperature

#Friction
md.friction.coefficient=50.*ones((md.mesh.numberofvertices,1))
md.friction.coefficient[numpy.nonzero(md.mask.groundedice_levelset<0.)[0]]=0.
md.friction.p=ones((md.mesh.numberofelements,1))
md.friction.q=ones((md.mesh.numberofelements,1))

#Ice shelf melting and surface mass balance 
md.basalforcings.melting_rate=zeros((md.mesh.numberofvertices,1))
md.basalforcings.melting_rate[numpy.nonzero(md.mask.groundedice_levelset<0.)[0]]=0.
md.surfaceforcings.mass_balance=15*numpy.ones((md.mesh.numberofvertices,1))

#Numerical parameters
md.stressbalance.viscosity_overshoot=0.3
md.masstransport.stabilization=1
md.thermal.stabilization=1
md.verbose=verbose(0)
md.settings.waitonlock=30
md.timestepping.time_step=1.
md.timestepping.final_time=3.
md.stressbalance.restol=0.05
md.stressbalance.reltol=0.005
md.steadystate.reltol=0.005
md.stressbalance.abstol=float('NaN')

#Boundary conditions:
md=SetMarineIceSheetBC(md)
pos=numpy.nonzero(md.mesh.vertexonboundary)
md.balancethickness.spcthickness[pos]=md.geometry.thickness[pos]
md.masstransport.spcthickness[pos]=md.geometry.thickness[pos]

#Change name so that no test have the same name
if len(inspect.stack()) > 2:
	md.miscellaneous.name = os.path.basename(inspect.stack()[2][1]).split('.')[0]
