from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from WriteData import *

class mask(object):
	"""
	MASK class definition

	   Usage:
	      mask=mask();
	"""

	def __init__(self): # {{{
		self.elementonfloatingice = float('NaN')
		self.elementongroundedice = float('NaN')
		self.vertexonfloatingice  = float('NaN')
		self.vertexongroundedice  = float('NaN')
		self.ice_levelset         = float('NaN')
		self.groundedice_levelset = float('NaN')

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(self): # {{{
		string="   masks:"

		string="%s\n%s"%(string,fielddisplay(self,"elementonfloatingice","element on floating ice flags list"))
		string="%s\n%s"%(string,fielddisplay(self,"vertexonfloatingice","vertex on floating ice flags list"))
		string="%s\n%s"%(string,fielddisplay(self,"elementongroundedice","element on grounded ice list"))
		string="%s\n%s"%(string,fielddisplay(self,"vertexongroundedice","vertex on grounded ice flags list"))
		string="%s\n%s"%(string,fielddisplay(self,"groundedice_levelset","is ice grounded ? grounded ice if > 0, grounding line position if = 0, floating ice if < 0"))
		string="%s\n%s"%(string,fielddisplay(self,"ice_levelset","presence of ice if > 0, icefront position if = 0, no ice if < 0"))
		return string
		#}}}
	def setdefaultparameters(self): # {{{
		return self
	#}}}
	def checkconsistency(self,md,solution,analyses):    # {{{

		md = checkfield(md,'mask.elementonfloatingice','size',[md.mesh.numberofelements],'values',[0,1])
		md = checkfield(md,'mask.elementongroundedice','size',[md.mesh.numberofelements],'values',[0,1])
		md = checkfield(md,'mask.vertexonfloatingice' ,'size',[md.mesh.numberofvertices],'values',[0,1])
		md = checkfield(md,'mask.vertexongroundedice' ,'size',[md.mesh.numberofvertices],'values',[0,1])
		md = checkfield(md,'mask.groundedice_levelset','size',[md.mesh.numberofvertices])
		md = checkfield(md,'mask.ice_levelset'        ,'size',[md.mesh.numberofvertices])
		isice=numpy.array(md.mask.ice_levelset>0,int)
		totallyicefree=(numpy.sum(isice[md.mesh.elements-1],axis=1)==0).astype(int)
		if any(totallyicefree):
			raise TypeError("elements with no ice not implemented yet, each element should have at least one vertex with md.mask.ice_levelset > 0")

		return md
	# }}}
	def marshall(self,md,fid):    # {{{
		WriteData(fid,'object',self,'fieldname','groundedice_levelset','format','DoubleMat','mattype',1)
		WriteData(fid,'object',self,'fieldname','ice_levelset','format','DoubleMat','mattype',1)
	# }}}
