/*
 * CreateNodesMasstransport.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	CreateNodesMasstransport(Nodes** pnodes, IoModel* iomodel){

	/*Fetch parameters: */
	int  stabilization;
	iomodel->Constant(&stabilization,MasstransportStabilizationEnum);

	/*Check in 3d*/
	if(stabilization==3 && iomodel->dim==3) _error_("DG 3d not implemented yet");

	/*Create Nodes either DG or CG depending on stabilization*/
	iomodel->FetchData(3,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,FlowequationVertexEquationEnum);
	if(stabilization!=3){
		CreateNodes(pnodes,iomodel,MasstransportAnalysisEnum,P1Enum);
	}
	else{
		CreateNodes(pnodes,iomodel,MasstransportAnalysisEnum,P1DGEnum);
	}
	iomodel->DeleteData(3,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,FlowequationVertexEquationEnum);
}
