%MASK class definition
%
%   Usage:
%      mask=mask();

classdef mask
	properties (SetAccess=public) 
		elementonfloatingice = NaN;
		elementongroundedice = NaN;
		vertexonfloatingice  = NaN;
		vertexongroundedice  = NaN;
		vertexonrock         = NaN;
		groundedice_levelset = NaN;
		ice_levelset         = NaN;
	end
	methods
		function obj = mask(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			md = checkfield(md,'mask.elementonfloatingice','size',[md.mesh.numberofelements 1],'values',[0 1]);
			md = checkfield(md,'mask.elementongroundedice','size',[md.mesh.numberofelements 1],'values',[0 1]);
			md = checkfield(md,'mask.vertexonfloatingice' ,'size',[md.mesh.numberofvertices 1],'values',[0 1]);
			md = checkfield(md,'mask.vertexongroundedice' ,'size',[md.mesh.numberofvertices 1],'values',[0 1]);
			md = checkfield(md,'mask.groundedice_levelset','size',[md.mesh.numberofvertices 1]);
			md = checkfield(md,'mask.ice_levelset'        ,'size',[md.mesh.numberofvertices 1]);
			isice=(md.mask.ice_levelset>0);
			if any(sum(isice(md.mesh.elements),2)==0),
				error('elements with no ice not implemented yet, each element should have at least one vertex with md.mask.ice_levelset > 0');
			end
			%md = checkfield(md,'mask.vertexonrock'      ,'size',[md.mesh.numberofvertices 1],'values',[0 1]);
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   masks:'));

			fielddisplay(obj,'elementonfloatingice','element on floating ice flags list');
			fielddisplay(obj,'vertexonfloatingice','vertex on floating ice flags list');
			fielddisplay(obj,'elementongroundedice','element on grounded ice  list');
			fielddisplay(obj,'vertexongroundedice','vertex on grounded ice flags list');
			fielddisplay(obj,'vertexonrock','vertex on rock flags list');
			fielddisplay(obj,'groundedice_levelset','is ice grounded ? grounded ice if > 0, grounding line position if = 0, floating ice if < 0');
			fielddisplay(obj,'ice_levelset','presence of ice if > 0, icefront position if = 0, no ice if < 0');
		end % }}}
		function marshall(obj,md,fid) % {{{
			WriteData(fid,'object',obj,'fieldname','groundedice_levelset','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'fieldname','ice_levelset','format','DoubleMat','mattype',1);
		end % }}}
	end
end
