#!/bin/bash
#This bash script calls the nightlyrun.m matlab file to run our nightly test decks. 
#It then processes the results and sends an email to the Ice developpers.

#some functions
function timer()
{
	if [[ $# -eq 0 ]]; then
		echo $(date '+%s')
	else
		local  stime=$1
		etime=$(date '+%s')

		if [[ -z "$stime" ]]; then stime=$etime; fi

		dt=$((etime - stime))
		ds=$((dt % 60))
		dm=$(((dt / 60) % 60))
		dh=$((dt / 3600))
		printf '%d:%02d:%02d' $dh $dm $ds
	fi
}
function todaydate()
{
	export today=`date | awk '{printf("%s-%s-%s",$2,$3,$6);}'`; 
	suffix=`date | awk '{printf("%s-%s-%s",$2,$3,$6);}'`			 
	echo $suffix;			 
} 

#get configs
if [ $# -ne 1 ];
then
	#no config file specified: exit
	echo "no config file specified. Exiting..."
	exit 1
else
	#launch nightly run (get start time)
	source $1;
	START_TIME=$(timer)
fi

#create nightly run variables
export TODAY=$(todaydate);
export HOST_NAME=`hostname`;
export ISSM_RELEASE="issm"
export OS

#create ISSM variables
export ISSM_DIR
export ISSM_ARCH

#Erase previous code and Fetch the new one
#rm -rf trunk
#svn checkout $REPOSITORY

#install ISSM

#1: modify some variables
cd $ISSM_DIR/etc

#source environment variables with new matlab path
source environment.sh MATLAB_DIR=$MATLAB_PATH

#create simpler  cluster.rc file, with only the cluster we are interested in.
cat << END > cluster.rc
begin
cluster_name=$HOST_NAME
cluster_codepath=$ISSM_DIR/bin
cluster_executionpath=$EXECUTION_PATH

end
END

if [[ $SKIPPACKAGESCOMPILATION  == "yes" ]]
then
	#erase externapackages, and link with externalpackages_dir
	cd $ISSM_DIR
	rm -rf externalpackages
	ln -s $EXTERNALPACKAGESDIR ./

	rm -rf devpackages
	ln -s $DEVPACKAGESDIR ./
else
	#2: install some required external packages
	cd $ISSM_DIR/externalpackages
	for ep in $EXTERNALPACKAGES
	do 
		cd $ep
		cp configs/$OS/* .
		./install.sh $NUMCPUS
		cd ..
	done

	#3: install automake and autoconf
	cd $ISSM_DIR/devpackages
	make
	cd ..
fi

#3: generate MakeFiles
sh scripts/automakererun.sh
sh configs/$OS/$OS.sh

#4: compile and install ISSM
make -j $NUMCPUS
make -j $NUMCPUS install
INSTAL_TIME=$(timer)
export ELAPSED_INSTAL=$(timer $START_TIME)

#Launch matlab and the nightly run script
matlab -nojvm -nosplash  > ./nightlylong.log << EOF 
startup
nightlyrun($PACKAGES);
EOF

#removed unused lines to deal with a smaller file
cat nightlylong.log | egrep 'difference: |NIGHTLYRUNTERMINATEDCORRECTLY' > nightly.log
#rm nightlylong.log

#Build html report
export ELAPSED_RUN=$(timer $INSTAL_TIME)
export ELAPSED_TOTAL=$(timer $START_TIME)
./cron/report.sh
		
#send mail
source cron/mailinglist
for i in `echo $MAILINGLIST`; do

	if [[ "$OS" == "winxp32" ]]
	then
		email -html -f "ISSM Nightly run $EMAIL_ADRESS" -s "Nightly runs of $ISSM_RELEASE , operating system: $OS. " $i < report.html 
	else 
		if [[ "$OS" == "linux64" ]]
		then
			cat - report.html <<HERE | /usr/lib/sendmail  -oi -t
From: "ISSM Nightly run" <$EMAIL_ADRESS>
To: $i
Subject: Nightly runs of $ISSM_RELEASE , operating system: $OS.
Mime-Version: 1.0
Content-Type: text/html
HERE
		else
			cat - report.html <<HERE | /usr/sbin/sendmail  -oi -t
From: "ISSM Nightly run" <$EMAIL_ADRESS>
To: $i
Subject: Nightly runs of $ISSM_RELEASE , operating system: $OS.
Mime-Version: 1.0
Content-Type: text/html
HERE
		fi
	fi

done

#Erase log and error logs
#rm -rf nightly.log report.html

#Erase ice code
#cd ..
#rm -rf trunk/
