function scpout(host,path,packages)
%SCPOUT send packages to a host, using scp on unix, and pscp on windows
%
%   usage: scpout(host,path,packages)
%
%

%get hostname
hostname=oshostname();

%if hostname and host are the same, do a simple copy

if strcmpi(host,hostname),
	for i=1:numel(packages),
		copyfile(packages{i},path);
	end
else 
	if ispc,
		%use the putty project pscp.exe: it should be in the path.
		
		%get ISSM_DIR variable
		[status,ISSM_DIR]=system('echo [%ISSM_DIR_WIN%]');
		if status, 
			error('scpout error message: could not find ISSM_DIR_WIN envirnoment variable');
		end
		ISSM_DIR=ISSM_DIR(2:end-2);

		username=input('Username: (quoted string) ');
		password=input('Password: (quoted string) ');

		for i=1:numel(packages),
			[status,result]=system([ISSM_DIR '/externalpackages/ssh/pscp.exe -l "' username '" -pw "' password '" ' packages{i} ' ' host ':' path]);
			if status, 
				error('scpout error message: could not call putty pscp');
			end
		end

	else
		%just use standard unix scp
		%create string of packages being sent
		string='';
		for i=1:numel(packages),
			string=[string ' ' packages{i}];
		end
		string=[string ' '];
		[status,result]=system(['scp ' string host ':' path]);
		if status, 
			error('scpout error message: could not call scp on *nix system');
		end
	end
end
