function md=reorder(md)
%REORDER - reorder nodes and elements of a model
%
%   Usage: 
%      md=reorder(md)

%some checks
if md.counter<1,
	error('reorder error message: no existing mesh, exiting...')
end
if strcmpi(md.type,'3d'),
	error('reorder error message: 3d models not supported yet, exiting...')
end
disp('reorder warning: only the mesh fields are reorder. The model needs to be reparameterized');

%reorder elements
newelements=randperm(md.numberofelements)';
tnewelements=zeros(md.numberofelements,1);tnewelements(newelements)=[1:md.numberofelements]';

%reorder nodes
newgrids=randperm(md.numberofgrids)';
tnewgrids=zeros(md.numberofgrids,1);tnewgrids(newgrids)=[1:md.numberofgrids]';

%update all fields
md.elements=tnewgrids(md.elements(newelements,:));
md.segments=[tnewgrids(md.segments(:,1)) tnewgrids(md.segments(:,2)) tnewelements(md.segments(:,3))];
md.x=md.x(newgrids);
md.y=md.y(newgrids);
md.z=md.z(newgrids);
md.gridonboundary=zeros(md.numberofgrids,1); md.gridonboundary(md.segments(:,1:2))=1;
