function md=loadresultsfromcluster(md)
%LOADRESULTSFROMCLUSTER - load results of solution sequence from cluster
%
%   Usage:
%      md=loadresultsfromcluster(md);

%Get cluster.rc location
cluster_rc_location=which('cluster.rc');

%Figure out parameters for this particular cluster
[codepath,executionpath]=ClusterParameters(md.cluster,cluster_rc_location);

%What packages are we picking up from remote cluster
packages={[md.name '.outlog'],[md.name '.errlog'], [md.name '.outbin']};
if md.qmu_analysis,
	packages{end+1}=[md.name '.qmu.err'];
	packages{end+1}=[md.name '.qmu.out'];
	packages{end+1}='dakota_tabular.dat';
end

%copy files from cluster to present directory
scpin(md.cluster, executionpath, packages);

%read log files onto  fields
md.errlog=readfile([md.name '.errlog']);
md.outlog=readfile([md.name '.outlog']);

if ~isempty(md.errlog),
	disp(['loadresultsfromcluster info message: error during solution. Check your errlog and outlog model fields']);
end

%If we are here, no errors in the solution sequence, call loadresultsfromdisk.
md=loadresultsfromdisk(md,[md.name '.outbin']);

%erase the log and output files
system(['rm -rf ' md.name '.outlog ' md.name '.errlog ' md.name '.outbin ' md.name '.lock ']);
%erase input files
system(['rm -rf ' md.name '.bin ' md.name '.queue ']);
