function md=LaunchQueueJobGeneric(md,executionpath,options)
%LAUNCHQUEUEJOBGENERIC - ...
%
%   Usage:
%      LaunchQueueJobGeneric(md,executionpath)

%first, check we have the binary file and the queueing script
if ~exist([ md.name '.bin'],'file'),
	error('LaunchQueueJobGeneric error message: Binary input file missing, cannot go forward');
end

if ~exist([ md.name '.queue'],'file'),
	error('LaunchQueueJobGeneric error message: queueing script issing, cannot go forward');
end

if ~strcmpi(options.batch,'yes'),

	%what files are we sending?
	packages={[md.name '.bin'],[md.name '.queue']};
	if md.qmu_analysis,
		packages{end+1}=[md.name '.qmu.in '];
	end

	disp('uploading input file and queueing script');
	scpout(md.cluster,executionpath,packages);
	
	disp('launching solution sequence on remote cluster');
	issmssh(md.cluster,['cd ' executionpath ' && source ' md.name '.queue ']);

	%waitonlock will work if the lock is on the same machine only: 
	if ~strcmpi(hostname,md.cluster),
		disp('solution launched on remote cluster. log in to detect job completion, then run md=loadresultsfromcluster(md)');
		md.waitonlock=0;
	end

else
	disp('batch mode requested: not launching job interactively');
	disp(['launch solution sequence by copying files ' md.name '.bin' ',' md.name '.queue and ' md.name '.qmu.in, onto remote cluster ' md.cluster]);
	disp(['   then log int ' md.cluster ' and source queue file ' md.name '.queue']);
	md.waitonlock=0;
end
