/*!\file InputToResultx
 * \brief: transfer an input to the results  dataset inside the elements
 */

#include "./InputToResultx.h"
#include "../../shared/shared.h"
#include "../../classes/classes.h"
#include "../../toolkits/toolkits.h"

void InputToResultx(FemModel* femmodel,int enum_type){

	/*intermediary:*/
	int        step;
	IssmDouble time;
	Element   *element = NULL;

	/*Get time and step*/
	femmodel->parameters->FindParam(&step,StepEnum);
	femmodel->parameters->FindParam(&time,TimeEnum);

	/*Go through elemnets, and ask each element to transfer the enum_type input into the results dataset, with step and time information: */
	for(int i=0;i<femmodel->elements->Size();i++){
		element=dynamic_cast<Element*>(femmodel->elements->GetObjectByOffset(i));
		element->InputToResult(enum_type,step,time);
	}

}
